/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolderDescriptor;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import com.cloudbees.hudson.plugins.folder.ChildNameGenerator;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetric;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import com.cloudbees.hudson.plugins.folder.icons.StockFolderIcon;
import com.cloudbees.hudson.plugins.folder.views.AbstractFolderViewHolder;
import com.cloudbees.hudson.plugins.folder.views.DefaultFolderViewHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.AllView;
import hudson.model.Descriptor;
import hudson.model.HealthReport;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.ModifiableViewGroup;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.ViewGroupMixIn;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.search.CollectionSearchIndex;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.search.SearchItem;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.CaseInsensitiveComparator;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.Function1;
import hudson.util.HttpResponses;
import hudson.views.DefaultViewsTabBar;
import hudson.views.ViewsTabBar;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.model.ProjectNamingStrategy;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerOverridable;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class AbstractFolder<I extends TopLevelItem>
extends AbstractItem
implements TopLevelItem,
ItemGroup<I>,
ModifiableViewGroup,
StaplerFallback,
ModelObjectWithChildren,
StaplerOverridable {
    private static final Logger LOGGER = Logger.getLogger(AbstractFolder.class.getName());
    private static final Random ENTROPY = new Random();
    private static final int HEALTH_REPORT_CACHE_REFRESH_MIN = Math.max(10, Math.min(1440, Integer.getInteger(AbstractFolder.class.getName() + ".healthReportCacheRefreshMin", 60)));
    private static long loadingTick;
    private static final AtomicInteger jobTotal;
    private static final AtomicInteger jobEncountered;
    private static final AtomicBoolean loadJobTotalRan;
    private static final int TICK_INTERVAL = 15000;
    protected transient Map<String, I> items = new CopyOnWriteMap.Tree(CaseInsensitiveComparator.INSTANCE);
    private DescribableList<AbstractFolderProperty<?>, AbstractFolderPropertyDescriptor> properties;
    private AbstractFolderViewHolder folderViews;
    @Deprecated
    private transient CopyOnWriteArrayList<View> views;
    @Deprecated
    private volatile transient ViewsTabBar viewsTabBar;
    @Deprecated
    private volatile transient String primaryView;
    private transient ViewGroupMixIn viewGroupMixIn;
    private DescribableList<FolderHealthMetric, FolderHealthMetricDescriptor> healthMetrics;
    private FolderIcon icon;
    private volatile transient long nextHealthReportsRefreshMillis;
    private volatile transient List<HealthReport> healthReports;

    @Initializer(before=InitMilestone.JOB_LOADED, fatal=false)
    public static void loadJobTotal() {
        if (!loadJobTotalRan.compareAndSet(false, true)) {
            return;
        }
        AbstractFolder.scan(new File(Jenkins.getActiveInstance().getRootDir(), "jobs"), 0);
    }

    private static void scan(File d, int depth) {
        File[] projects = d.listFiles();
        if (projects == null) {
            return;
        }
        for (File project : projects) {
            File jobs;
            if (!new File(project, "config.xml").isFile()) continue;
            if (depth > 0) {
                jobTotal.incrementAndGet();
            }
            if (!(jobs = new File(project, "jobs")).isDirectory()) continue;
            AbstractFolder.scan(jobs, depth + 1);
        }
    }

    protected AbstractFolder(ItemGroup parent, String name) {
        super(parent, name);
    }

    protected void init() {
        if (this.properties == null) {
            this.properties = new DescribableList((Saveable)this);
        } else {
            this.properties.setOwner((Saveable)this);
        }
        for (AbstractFolderProperty p : this.properties) {
            p.setOwner(this);
        }
        if (this.icon == null) {
            this.icon = this.newDefaultFolderIcon();
        }
        this.icon.setOwner(this);
        if (this.folderViews == null) {
            if (this.views != null && !this.views.isEmpty()) {
                if (this.primaryView != null) {
                    try {
                        Method migrateLegacyPrimaryAllViewLocalizedName = AllView.class.getMethod("migrateLegacyPrimaryAllViewLocalizedName", List.class, String.class);
                        this.primaryView = (String)migrateLegacyPrimaryAllViewLocalizedName.invoke(null, this.views, this.primaryView);
                    }
                    catch (NoSuchMethodException migrateLegacyPrimaryAllViewLocalizedName) {
                    }
                    catch (IllegalAccessException migrateLegacyPrimaryAllViewLocalizedName) {
                    }
                    catch (InvocationTargetException migrateLegacyPrimaryAllViewLocalizedName) {
                        // empty catch block
                    }
                }
                this.folderViews = new DefaultFolderViewHolder(this.views, this.primaryView, (ViewsTabBar)(this.viewsTabBar == null ? this.newDefaultViewsTabBar() : this.viewsTabBar));
            } else {
                this.folderViews = this.newFolderViewHolder();
            }
            this.views = null;
            this.primaryView = null;
            this.viewsTabBar = null;
        }
        this.viewGroupMixIn = new ViewGroupMixIn((ViewGroup)this){

            protected List<View> views() {
                return AbstractFolder.this.folderViews.getViews();
            }

            protected String primaryView() {
                String primaryView = AbstractFolder.this.folderViews.getPrimaryView();
                return primaryView == null ? AbstractFolder.this.folderViews.getViews().get(0).getViewName() : primaryView;
            }

            protected void primaryView(String name) {
                AbstractFolder.this.folderViews.setPrimaryView(name);
            }

            public void addView(View v) throws IOException {
                if (AbstractFolder.this.folderViews.isViewsModifiable()) {
                    super.addView(v);
                }
            }

            public boolean canDelete(View view) {
                return AbstractFolder.this.folderViews.isViewsModifiable() && super.canDelete(view);
            }

            public synchronized void deleteView(View view) throws IOException {
                if (AbstractFolder.this.folderViews.isViewsModifiable()) {
                    super.deleteView(view);
                }
            }
        };
        if (this.healthMetrics == null) {
            ArrayList<FolderHealthMetric> metrics = new ArrayList<FolderHealthMetric>();
            for (FolderHealthMetricDescriptor d : FolderHealthMetricDescriptor.all()) {
                FolderHealthMetric metric = d.createDefault();
                if (metric == null) continue;
                metrics.add(metric);
            }
            this.healthMetrics = new DescribableList((Saveable)this, metrics);
        }
    }

    protected DefaultViewsTabBar newDefaultViewsTabBar() {
        return new DefaultViewsTabBar();
    }

    protected AbstractFolderViewHolder newFolderViewHolder() {
        CopyOnWriteArrayList<View> views = new CopyOnWriteArrayList<View>();
        try {
            this.initViews(views);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to set up the initial view", e);
        }
        return new DefaultFolderViewHolder(views, null, (ViewsTabBar)this.newDefaultViewsTabBar());
    }

    protected FolderIcon newDefaultFolderIcon() {
        return new StockFolderIcon();
    }

    protected void initViews(List<View> views) throws IOException {
        AllView v = new AllView("All", (ViewGroup)this);
        views.add((View)v);
    }

    public void addAction(Action a) {
        super.getActions().add(a);
    }

    public void replaceAction(Action a) {
        this.addOrReplaceAction(a);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public boolean addOrReplaceAction(@Nonnull Action a) {
        if (a == null) {
            throw new IllegalArgumentException("Action must be non-null");
        }
        ArrayList<Action> old = new ArrayList<Action>(1);
        List current = super.getActions();
        boolean found = false;
        for (Action a2 : current) {
            if (!found && a.equals(a2)) {
                found = true;
                continue;
            }
            if (a2.getClass() != a.getClass()) continue;
            old.add(a2);
        }
        current.removeAll(old);
        if (!found) {
            this.addAction(a);
        }
        return !found || !old.isEmpty();
    }

    public boolean removeAction(@Nullable Action a) {
        if (a == null) {
            return false;
        }
        return super.getActions().removeAll(Collections.singleton(a));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public boolean removeActions(@Nonnull Class<? extends Action> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Action type must be non-null");
        }
        ArrayList<Action> old = new ArrayList<Action>();
        List current = super.getActions();
        for (Action a : current) {
            if (!clazz.isInstance(a)) continue;
            old.add(a);
        }
        return current.removeAll(old);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public boolean replaceActions(@Nonnull Class<? extends Action> clazz, Action a) {
        if (clazz == null) {
            throw new IllegalArgumentException("Action type must be non-null");
        }
        if (a == null) {
            throw new IllegalArgumentException("Action must be non-null");
        }
        ArrayList<Action> old = new ArrayList<Action>();
        List current = super.getActions();
        boolean found = false;
        for (Action a1 : current) {
            if (!found && a.equals(a1)) {
                found = true;
                continue;
            }
            if (!clazz.isInstance(a1) || a.equals(a1)) continue;
            old.add(a1);
        }
        current.removeAll(old);
        if (!found) {
            this.addAction(a);
        }
        return !old.isEmpty() || !found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <K, V extends TopLevelItem> Map<K, V> loadChildren(AbstractFolder<V> parent, File modulesDir, Function1<? extends K, ? super V> key) {
        CopyOnWriteMap.Tree configurations = new CopyOnWriteMap.Tree();
        if (!modulesDir.isDirectory() && !modulesDir.mkdirs()) {
            LOGGER.log(Level.SEVERE, "Could not create {0} for folder {1}", new Object[]{modulesDir, parent.getFullName()});
            return configurations;
        }
        File[] subdirs = modulesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory();
            }
        });
        if (subdirs == null) {
            return configurations;
        }
        ChildNameGenerator<AbstractFolder<V>, V> childNameGenerator = super.childNameGenerator();
        HashMap<String, TopLevelItem> byDirName = new HashMap<String, TopLevelItem>();
        if (parent.items != null) {
            if (childNameGenerator == null) {
                for (TopLevelItem item : parent.items.values()) {
                    byDirName.put(item.getName(), item);
                }
            } else {
                for (TopLevelItem item : parent.items.values()) {
                    String itemName = childNameGenerator.dirNameFromItem(parent, item);
                    if (itemName == null) {
                        itemName = childNameGenerator.dirNameFromLegacy(parent, item.getName());
                    }
                    byDirName.put(itemName, item);
                }
            }
        }
        File[] fileArray = subdirs;
        int n = fileArray.length;
        int n2 = 0;
        while (true) {
            block56: {
                if (n2 >= n) {
                    return configurations;
                }
                Object subdir = fileArray[n2];
                try {
                    boolean itemNeedsSave;
                    TopLevelItem item;
                    block61: {
                        String name;
                        boolean legacy;
                        String childName;
                        block60: {
                            if (childNameGenerator == null) {
                                childName = ((File)subdir).getName();
                                legacy = false;
                            } else {
                                File nameFile = new File((File)subdir, "name-utf8.txt");
                                if (nameFile.isFile()) {
                                    childName = StringUtils.trimToNull((String)FileUtils.readFileToString((File)nameFile, (String)"UTF-8"));
                                    if (childName == null) {
                                        LOGGER.log(Level.WARNING, "{0} was empty, assuming child name is {1}", new Object[]{nameFile, ((File)subdir).getName()});
                                        legacy = true;
                                        childName = ((File)subdir).getName();
                                    } else {
                                        legacy = false;
                                    }
                                } else {
                                    legacy = true;
                                    childName = ((File)subdir).getName();
                                }
                            }
                            item = (TopLevelItem)byDirName.get(childName);
                            itemNeedsSave = false;
                            if (item != null) break block60;
                            XmlFile xmlFile = Items.getConfigFile((File)subdir);
                            if (xmlFile.exists()) {
                                String name2;
                                block57: {
                                    item = (TopLevelItem)xmlFile.read();
                                    if (childNameGenerator == null) {
                                        name2 = ((File)subdir).getName();
                                    } else {
                                        String dirName = childNameGenerator.dirNameFromItem(parent, item);
                                        if (dirName == null) {
                                            dirName = childNameGenerator.dirNameFromLegacy(parent, childName);
                                            BulkChange bc = new BulkChange((Saveable)item);
                                            try {
                                                childNameGenerator.recordLegacyName(parent, item, childName);
                                                itemNeedsSave = true;
                                            }
                                            catch (IOException e) {
                                                LOGGER.log(Level.WARNING, "Ignoring {0} as could not record legacy name", subdir);
                                                break block56;
                                            }
                                            finally {
                                                bc.abort();
                                            }
                                        }
                                        if (!((File)subdir).getName().equals(dirName)) {
                                            File newSubdir = parent.getRootDirFor(dirName);
                                            if (newSubdir.exists()) {
                                                LOGGER.log(Level.WARNING, "Ignoring {0} as folder naming rules collide with {1}", new Object[]{subdir, newSubdir});
                                                break block56;
                                            }
                                            LOGGER.log(Level.INFO, "Moving {0} to {1} in accordance with folder naming rules", new Object[]{subdir, newSubdir});
                                            if (!((File)subdir).renameTo(newSubdir)) {
                                                LOGGER.log(Level.WARNING, "Failed to move {0} to {1}. Ignoring this item", new Object[]{subdir, newSubdir});
                                                break block56;
                                            }
                                        }
                                        File nameFile = new File(parent.getRootDirFor(dirName), "name-utf8.txt");
                                        name2 = childNameGenerator.itemNameFromItem(parent, item);
                                        if (name2 == null) {
                                            name2 = childNameGenerator.itemNameFromLegacy(parent, childName);
                                            FileUtils.writeStringToFile((File)nameFile, (String)name2, (String)"UTF-8");
                                            BulkChange bc = new BulkChange((Saveable)item);
                                            try {
                                                childNameGenerator.recordLegacyName(parent, item, childName);
                                                itemNeedsSave = true;
                                                break block57;
                                            }
                                            catch (IOException e) {
                                                LOGGER.log(Level.WARNING, "Ignoring {0} as could not record legacy name", subdir);
                                                break block56;
                                            }
                                            finally {
                                                bc.abort();
                                            }
                                        }
                                        if (!childName.equals(name2) || legacy) {
                                            FileUtils.writeStringToFile((File)nameFile, (String)name2, (String)"UTF-8");
                                        }
                                    }
                                }
                                item.onLoad(parent, name2);
                                break block61;
                            } else {
                                LOGGER.log(Level.WARNING, "could not find file " + xmlFile.getFile());
                                break block56;
                            }
                        }
                        if (childNameGenerator == null) {
                            name = ((File)subdir).getName();
                        } else {
                            BulkChange bc;
                            block58: {
                                File nameFile = new File((File)subdir, "name-utf8.txt");
                                name = childNameGenerator.itemNameFromItem(parent, item);
                                if (name == null) {
                                    name = childNameGenerator.itemNameFromLegacy(parent, childName);
                                    FileUtils.writeStringToFile((File)nameFile, (String)name, (String)"UTF-8");
                                    bc = new BulkChange((Saveable)item);
                                    try {
                                        childNameGenerator.recordLegacyName(parent, item, childName);
                                        itemNeedsSave = true;
                                        break block58;
                                    }
                                    catch (IOException e) {
                                        LOGGER.log(Level.WARNING, "Ignoring {0} as could not record legacy name", subdir);
                                        break block56;
                                    }
                                    finally {
                                        bc.abort();
                                    }
                                }
                                if (!childName.equals(name) || legacy) {
                                    FileUtils.writeStringToFile((File)nameFile, (String)name, (String)"UTF-8");
                                }
                            }
                            if (!((File)subdir).getName().equals(name) && item instanceof AbstractItem && ((AbstractItem)item).getDisplayNameOrNull() == null) {
                                bc = new BulkChange((Saveable)item);
                                try {
                                    ((AbstractItem)item).setDisplayName(childName);
                                }
                                finally {
                                    bc.abort();
                                }
                            }
                        }
                        item.onLoad(parent, name);
                    }
                    if (itemNeedsSave) {
                        try {
                            item.save();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Could not update {0} after applying folder naming rules", item.getFullName());
                        }
                    }
                    configurations.put(key.call((Object)item), (Object)item);
                }
                catch (Exception e) {
                    Logger.getLogger(ItemGroupMixIn.class.getName()).log(Level.WARNING, "could not load " + subdir, e);
                }
            }
            ++n2;
        }
    }

    protected final I itemsPut(String name, I item) {
        ChildNameGenerator<AbstractFolder<I>, I> childNameGenerator = this.childNameGenerator();
        if (childNameGenerator != null) {
            String oldName;
            File nameFile = new File(this.getRootDirFor(item), "name-utf8.txt");
            if (nameFile.isFile()) {
                try {
                    oldName = StringUtils.trimToNull((String)FileUtils.readFileToString((File)nameFile, (String)"UTF-8"));
                }
                catch (IOException e) {
                    oldName = null;
                }
            } else {
                oldName = null;
            }
            if (!name.equals(oldName)) {
                try {
                    FileUtils.writeStringToFile((File)nameFile, (String)name, (String)"UTF-8");
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not create " + nameFile);
                }
            }
        }
        return (I)((TopLevelItem)this.items.put(name, item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.init();
        final Thread t = Thread.currentThread();
        String n = t.getName();
        try {
            Item current;
            if (this.items == null && (current = parent.getItem(name)) != null && current.getClass() == ((Object)((Object)this)).getClass()) {
                this.items = ((AbstractFolder)current).items;
            }
            final ChildNameGenerator<AbstractFolder<I>, I> childNameGenerator = this.childNameGenerator();
            this.items = AbstractFolder.loadChildren(this, this.getJobsDir(), new Function1<String, I>(){

                public String call(I item) {
                    String fullName = item.getFullName();
                    t.setName("Loading job " + fullName);
                    float percentage = 100.0f * (float)jobEncountered.incrementAndGet() / (float)Math.max(1, jobTotal.get());
                    long now = System.currentTimeMillis();
                    if (loadingTick == 0L) {
                        loadingTick = now;
                    } else if (now - loadingTick > 15000L) {
                        LOGGER.log(Level.INFO, String.format("Loading job %s (%.1f%%)", fullName, Float.valueOf(percentage)));
                        loadingTick = now;
                    }
                    if (childNameGenerator == null) {
                        return item.getName();
                    }
                    String name = childNameGenerator.itemNameFromItem(AbstractFolder.this, item);
                    if (name == null) {
                        return childNameGenerator.itemNameFromLegacy(AbstractFolder.this, item.getName());
                    }
                    return name;
                }
            });
        }
        finally {
            t.setName(n);
        }
    }

    private ChildNameGenerator<AbstractFolder<I>, I> childNameGenerator() {
        return this.getDescriptor().childNameGenerator();
    }

    public AbstractFolderDescriptor getDescriptor() {
        return (AbstractFolderDescriptor)Jenkins.getActiveInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public DescribableList<AbstractFolderProperty<?>, AbstractFolderPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public void addProperty(AbstractFolderProperty p) throws IOException {
        if (!p.getDescriptor().isApplicable(((Object)((Object)this)).getClass())) {
            throw new IllegalArgumentException(((Object)((Object)p)).getClass().getName() + " cannot be applied to " + ((Object)((Object)this)).getClass().getName());
        }
        p.setOwner(this);
        this.properties.add((Object)p);
    }

    protected File getJobsDir() {
        return new File(this.getRootDir(), "jobs");
    }

    protected final File getRootDirFor(String name) {
        return new File(this.getJobsDir(), name);
    }

    public File getRootDirFor(I child) {
        ChildNameGenerator<AbstractFolder<I>, I> childNameGenerator = this.childNameGenerator();
        if (childNameGenerator == null) {
            return this.getRootDirFor(child.getName());
        }
        String name = childNameGenerator.dirNameFromItem(this, child);
        if (name == null) {
            name = childNameGenerator.dirNameFromLegacy(this, child.getName());
        }
        return this.getRootDirFor(name);
    }

    public String getUrlChildPrefix() {
        return "job";
    }

    public I getJob(String name) {
        return this.getItem(name);
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)this.getDescriptor().getDisplayName());
    }

    public Collection<?> getOverrides() {
        ArrayList r = new ArrayList();
        for (AbstractFolderProperty p : this.properties) {
            r.addAll(p.getItemContainerOverrides());
        }
        return r;
    }

    public void addView(View v) throws IOException {
        this.viewGroupMixIn.addView(v);
    }

    public boolean canDelete(View view) {
        return this.viewGroupMixIn.canDelete(view);
    }

    public void deleteView(View view) throws IOException {
        this.viewGroupMixIn.deleteView(view);
    }

    public View getView(String name) {
        return this.viewGroupMixIn.getView(name);
    }

    @Exported
    public Collection<View> getViews() {
        return this.viewGroupMixIn.getViews();
    }

    public AbstractFolderViewHolder getFolderViews() {
        return this.folderViews;
    }

    public void resetFolderViews() {
        this.folderViews = this.newFolderViewHolder();
    }

    @Exported
    public View getPrimaryView() {
        return this.viewGroupMixIn.getPrimaryView();
    }

    public void setPrimaryView(View v) {
        if (this.folderViews.isPrimaryModifiable()) {
            this.folderViews.setPrimaryView(v.getViewName());
        }
    }

    public void onViewRenamed(View view, String oldName, String newName) {
        this.viewGroupMixIn.onViewRenamed(view, oldName, newName);
    }

    public ViewsTabBar getViewsTabBar() {
        return this.folderViews.getTabBar();
    }

    public ItemGroup<? extends TopLevelItem> getItemGroup() {
        return this;
    }

    public List<Action> getViewActions() {
        return Collections.emptyList();
    }

    public View getStaplerFallback() {
        return this.getPrimaryView();
    }

    protected SearchIndexBuilder makeSearchIndex() {
        return super.makeSearchIndex().add((SearchIndex)new CollectionSearchIndex<TopLevelItem>(){

            protected SearchItem get(String key) {
                return Jenkins.getActiveInstance().getItem(key, this.grp());
            }

            protected Collection<TopLevelItem> all() {
                return Items.getAllItems(this.grp(), TopLevelItem.class);
            }

            protected String getName(TopLevelItem j) {
                return j.getRelativeNameFrom(this.grp());
            }

            private ItemGroup<?> grp() {
                return AbstractFolder.this;
            }
        });
    }

    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (View view : this.getViews()) {
            menu.add(view.getAbsoluteUrl(), view.getDisplayName());
        }
        return menu;
    }

    public synchronized void doCreateView(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, ParseException, Descriptor.FormException {
        this.checkPermission(View.CREATE);
        this.addView(View.create((StaplerRequest)req, (StaplerResponse)rsp, (ViewGroup)this));
    }

    public FormValidation doViewExistsCheck(@QueryParameter String value) {
        this.checkPermission(View.CREATE);
        String view = Util.fixEmpty((String)value);
        if (view == null) {
            return FormValidation.ok();
        }
        if (this.getView(view) == null) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.Hudson_ViewAlreadyExists((Object)view));
    }

    public HealthReport getBuildHealth() {
        List<HealthReport> reports = this.getBuildHealthReports();
        return reports.isEmpty() ? new HealthReport() : reports.get(0);
    }

    public void invalidateBuildHealthReports() {
        this.healthReports = null;
    }

    @Exported(name="healthReport")
    public List<HealthReport> getBuildHealthReports() {
        if (this.healthMetrics == null || this.healthMetrics.isEmpty()) {
            return Collections.emptyList();
        }
        List<HealthReport> reports = this.healthReports;
        if (reports != null && this.nextHealthReportsRefreshMillis > System.currentTimeMillis()) {
            return reports;
        }
        this.nextHealthReportsRefreshMillis = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(HEALTH_REPORT_CACHE_REFRESH_MIN * 3 / 4) + (long)ENTROPY.nextInt((int)TimeUnit.MINUTES.toMillis(HEALTH_REPORT_CACHE_REFRESH_MIN / 2));
        reports = new ArrayList<HealthReport>();
        ArrayList<FolderHealthMetric.Reporter> reporters = new ArrayList<FolderHealthMetric.Reporter>(this.healthMetrics.size());
        boolean recursive = false;
        boolean topLevelOnly = true;
        for (FolderHealthMetric metric : this.healthMetrics) {
            recursive = recursive || metric.getType().isRecursive();
            topLevelOnly = topLevelOnly && metric.getType().isTopLevelItems();
            reporters.add(metric.reporter());
        }
        for (Object p : this.getProperties()) {
            for (Object metric : ((AbstractFolderProperty)((Object)p)).getHealthMetrics()) {
                recursive = recursive || ((FolderHealthMetric)((Object)metric)).getType().isRecursive();
                topLevelOnly = topLevelOnly && ((FolderHealthMetric)((Object)metric)).getType().isTopLevelItems();
                reporters.add(((FolderHealthMetric)((Object)metric)).reporter());
            }
        }
        if (recursive) {
            Stack<Collection<I>> stack = new Stack<Collection<I>>();
            stack.push(this.getItems());
            if (topLevelOnly) {
                while (!stack.isEmpty()) {
                    for (Item item : (Iterable)stack.pop()) {
                        if (!(item instanceof TopLevelItem)) continue;
                        for (FolderHealthMetric.Reporter reporter : reporters) {
                            reporter.observe(item);
                        }
                        if (!(item instanceof Folder)) continue;
                        stack.push(((Folder)item).getItems());
                    }
                }
            } else {
                while (!stack.isEmpty()) {
                    for (Item item : (Iterable)stack.pop()) {
                        for (FolderHealthMetric.Reporter reporter : reporters) {
                            reporter.observe(item);
                        }
                        if (!(item instanceof Folder)) continue;
                        stack.push(((Folder)item).getItems());
                    }
                }
            }
        } else {
            for (Item item : this.getItems()) {
                for (FolderHealthMetric.Reporter reporter : reporters) {
                    reporter.observe(item);
                }
            }
        }
        for (FolderHealthMetric.Reporter reporter : reporters) {
            reports.addAll(reporter.report());
        }
        for (Object p : this.getProperties()) {
            reports.addAll(((AbstractFolderProperty)((Object)p)).getHealthReports());
        }
        Collections.sort(reports);
        this.healthReports = reports;
        return reports;
    }

    public DescribableList<FolderHealthMetric, FolderHealthMetricDescriptor> getHealthMetrics() {
        return this.healthMetrics;
    }

    public HttpResponse doLastBuild(StaplerRequest req) {
        return HttpResponses.redirectToDot();
    }

    public FolderIcon getIcon() {
        return this.icon;
    }

    public void setIcon(FolderIcon icon) {
        this.icon = icon;
        icon.setOwner(this);
    }

    public FolderIcon getIconColor() {
        return this.icon;
    }

    public Collection<? extends Job> getAllJobs() {
        HashSet jobs = new HashSet();
        for (Item i : this.getItems()) {
            jobs.addAll(i.getAllJobs());
        }
        return jobs;
    }

    @Exported(name="jobs")
    public Collection<I> getItems() {
        ArrayList<TopLevelItem> viewableItems = new ArrayList<TopLevelItem>();
        for (TopLevelItem item : this.items.values()) {
            if (!item.hasPermission(Item.READ)) continue;
            viewableItems.add(item);
        }
        return viewableItems;
    }

    public I getItem(String name) throws AccessDeniedException {
        if (this.items == null) {
            return null;
        }
        TopLevelItem item = (TopLevelItem)this.items.get(name);
        if (item == null) {
            return null;
        }
        if (!item.hasPermission(Item.READ)) {
            if (item.hasPermission(Item.DISCOVER)) {
                throw new AccessDeniedException("Please log in to access " + name);
            }
            return null;
        }
        return (I)item;
    }

    public void onRenamed(I item, String oldName, String newName) throws IOException {
        this.items.remove(oldName);
        this.items.put(newName, item);
        for (View v : this.folderViews.getViews()) {
            v.onJobRenamed(item, oldName, newName);
        }
        this.save();
    }

    public void onDeleted(I item) throws IOException {
        ItemListener.fireOnDeleted(item);
        this.items.remove(item.getName());
        for (View v : this.folderViews.getViews()) {
            v.onJobRenamed(item, item.getName(), null);
        }
        this.save();
    }

    /*
     * Exception decompiling
     */
    public void delete() throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isDisabled() {
        return false;
    }

    protected void setDisabled(boolean disabled) {
        throw new UnsupportedOperationException("must be implemented if supportsMakeDisabled is overridden");
    }

    protected boolean supportsMakeDisabled() {
        return false;
    }

    public void makeDisabled(boolean disabled) throws IOException {
        if (this.isDisabled() == disabled) {
            return;
        }
        if (disabled && !this.supportsMakeDisabled()) {
            return;
        }
        this.setDisabled(disabled);
        if (disabled && this instanceof Queue.Task) {
            Jenkins.getActiveInstance().getQueue().cancel((Queue.Task)this);
        }
        this.save();
        ItemListener.fireOnUpdated((Item)this);
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doDisable() throws IOException, ServletException {
        this.checkPermission(CONFIGURE);
        this.makeDisabled(true);
        return new HttpRedirect(".");
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doEnable() throws IOException, ServletException {
        this.checkPermission(CONFIGURE);
        this.makeDisabled(false);
        return new HttpRedirect(".");
    }

    public synchronized void save() throws IOException {
        if (this.folderViews != null) {
            this.folderViews.invalidateCaches();
        }
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        super.save();
        ItemListener.fireOnUpdated((Item)this);
    }

    public void renameTo(String newName) throws IOException {
        super.renameTo(newName);
    }

    public synchronized void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getPrimaryView().doSubmitDescription(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(CONFIGURE);
        req.setCharacterEncoding("UTF-8");
        JSONObject json = req.getSubmittedForm();
        BulkChange bc = new BulkChange((Saveable)this);
        try {
            this.description = json.getString("description");
            this.displayName = Util.fixEmpty((String)json.optString("displayNameOrNull"));
            if (this.folderViews.isTabBarModifiable() && json.has("viewsTabBar")) {
                this.folderViews.setTabBar((ViewsTabBar)req.bindJSON(ViewsTabBar.class, json.getJSONObject("viewsTabBar")));
            }
            if (this.folderViews.isPrimaryModifiable() && json.has("primaryView")) {
                this.folderViews.setPrimaryView(json.getString("primaryView"));
            }
            this.properties.rebuild(req, json, this.getDescriptor().getPropertyDescriptors());
            for (AbstractFolderProperty p : this.properties) {
                p.setOwner(this);
            }
            this.healthMetrics.replaceBy((Collection)req.bindJSONToList(FolderHealthMetric.class, json.get("healthMetrics")));
            this.icon = (FolderIcon)((Object)req.bindJSON(FolderIcon.class, req.getSubmittedForm().getJSONObject("icon")));
            this.icon.setOwner(this);
            this.submit(req, rsp);
            this.makeDisabled(json.optBoolean("disable"));
            this.save();
            bc.commit();
        }
        finally {
            bc.abort();
        }
        String newName = json.getString("name");
        ProjectNamingStrategy namingStrategy = Jenkins.getActiveInstance().getProjectNamingStrategy();
        if (newName != null && !newName.equals(this.name)) {
            Jenkins.checkGoodName((String)newName);
            namingStrategy.checkName(newName);
            rsp.sendRedirect("rename?newName=" + URLEncoder.encode(newName, "UTF-8"));
        } else {
            if (namingStrategy.isForceExistingJobs()) {
                namingStrategy.checkName(this.name);
            }
            FormApply.success((String)this.getSuccessfulDestination()).generateResponse(req, rsp, (Object)this);
        }
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    protected String getSuccessfulDestination() {
        return ".";
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public void doDoRename(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!this.hasPermission(CONFIGURE)) {
            this.checkPermission(CREATE);
            this.checkPermission(DELETE);
        }
        String newName = req.getParameter("newName");
        Jenkins.checkGoodName((String)newName);
        String blocker = this.renameBlocker();
        if (blocker != null) {
            rsp.sendRedirect("rename?newName=" + URLEncoder.encode(newName, "UTF-8") + "&blocker=" + URLEncoder.encode(blocker, "UTF-8"));
            return;
        }
        this.renameTo(newName);
        rsp.sendRedirect2("../" + newName);
    }

    @CheckForNull
    protected String renameBlocker() {
        for (Job job : this.getAllJobs()) {
            if (!job.isBuilding()) continue;
            return "Unable to rename a folder while a job inside it is building.";
        }
        return null;
    }

    private static void invalidateBuildHealthReports(Item item) {
        while (item != null) {
            if (item instanceof AbstractFolder) {
                ((AbstractFolder)item).invalidateBuildHealthReports();
            }
            if (!(item.getParent() instanceof Item)) break;
            item = (Item)item.getParent();
        }
    }

    static {
        jobTotal = new AtomicInteger();
        jobEncountered = new AtomicInteger();
        loadJobTotalRan = new AtomicBoolean();
    }

    @Extension
    public static class RunListenerImpl
    extends RunListener<Run> {
        public void onCompleted(Run run, @Nonnull TaskListener listener) {
            AbstractFolder.invalidateBuildHealthReports((Item)run.getParent());
        }

        public void onFinalized(Run run) {
            AbstractFolder.invalidateBuildHealthReports((Item)run.getParent());
        }

        public void onStarted(Run run, TaskListener listener) {
            AbstractFolder.invalidateBuildHealthReports((Item)run.getParent());
        }

        public void onDeleted(Run run) {
            AbstractFolder.invalidateBuildHealthReports((Item)run.getParent());
        }
    }

    @Extension
    public static class ItemListenerImpl
    extends ItemListener {
        public void onCreated(Item item) {
            AbstractFolder.invalidateBuildHealthReports(item);
        }

        public void onCopied(Item src, Item item) {
            AbstractFolder.invalidateBuildHealthReports(item);
        }

        public void onDeleted(Item item) {
            AbstractFolder.invalidateBuildHealthReports(item);
        }

        public void onRenamed(Item item, String oldName, String newName) {
            AbstractFolder.invalidateBuildHealthReports(item);
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            AbstractFolder.invalidateBuildHealthReports(item);
        }

        public void onUpdated(Item item) {
            AbstractFolder.invalidateBuildHealthReports(item);
        }
    }
}

