/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import antlr.ANTLRException;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Items;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.ListBoxModel;
import hudson.util.TimeUnit2;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class PeriodicFolderTrigger
extends Trigger<ComputedFolder<?>> {
    private final long interval;

    @DataBoundConstructor
    public PeriodicFolderTrigger(String interval) throws ANTLRException {
        super(PeriodicFolderTrigger.toCrontab(interval));
        long intervalMillis;
        this.interval = intervalMillis = PeriodicFolderTrigger.toIntervalMillis(interval);
    }

    private static String toCrontab(String interval) {
        long millis = PeriodicFolderTrigger.toIntervalMillis(interval);
        if (millis < TimeUnit2.MINUTES.toMillis(5L)) {
            return "* * * * *";
        }
        if (millis < TimeUnit2.MINUTES.toMillis(10L)) {
            return "*/12 * * * *";
        }
        if (millis < TimeUnit2.MINUTES.toMillis(30L)) {
            return "*/6 * * * *";
        }
        if (millis < TimeUnit2.HOURS.toMillis(1L)) {
            return "*/2 * * * *";
        }
        if (millis < TimeUnit2.HOURS.toMillis(8L)) {
            return "H * * * *";
        }
        return "H H * * *";
    }

    private static long toIntervalMillis(String interval) {
        TimeUnit2 units = TimeUnit2.MINUTES;
        if ((interval = interval.toLowerCase()).endsWith("h")) {
            units = TimeUnit2.HOURS;
            interval = StringUtils.removeEnd((String)interval, (String)"h");
        }
        if (interval.endsWith("m")) {
            interval = StringUtils.removeEnd((String)interval, (String)"m");
        } else if (interval.endsWith("d")) {
            units = TimeUnit2.DAYS;
            interval = StringUtils.removeEnd((String)interval, (String)"d");
        } else if (interval.endsWith("ms")) {
            units = TimeUnit2.SECONDS;
            interval = StringUtils.removeEnd((String)interval, (String)"ms");
        } else if (interval.endsWith("s")) {
            units = TimeUnit2.SECONDS;
            interval = StringUtils.removeEnd((String)interval, (String)"s");
        }
        long value = 0L;
        try {
            value = Long.parseLong(interval);
        }
        catch (NumberFormatException e) {
            value = 1L;
        }
        return Math.min(TimeUnit2.DAYS.toMillis(30L), Math.max(TimeUnit2.MINUTES.toMillis(1L), units.toMillis(value)));
    }

    public long getIntervalMillis() {
        return this.interval;
    }

    public String getInterval() {
        if (this.interval < TimeUnit2.SECONDS.toMillis(1L)) {
            return Long.toString(this.interval) + "ms";
        }
        if (this.interval < TimeUnit2.MINUTES.toMillis(1L)) {
            return Long.toString(TimeUnit2.MILLISECONDS.toSeconds(this.interval)) + "s";
        }
        if (this.interval < TimeUnit2.HOURS.toMillis(1L)) {
            return Long.toString(TimeUnit2.MILLISECONDS.toMinutes(this.interval)) + "m";
        }
        if (this.interval < TimeUnit2.DAYS.toMillis(1L)) {
            return Long.toString(TimeUnit2.MILLISECONDS.toHours(this.interval)) + "h";
        }
        return Long.toString(TimeUnit2.MILLISECONDS.toDays(this.interval)) + "d";
    }

    public void run() {
        long delay;
        FolderComputation computation = ((ComputedFolder)this.job).getComputation();
        if (computation != null && (delay = System.currentTimeMillis() - computation.getTimestamp().getTimeInMillis()) < this.interval) {
            return;
        }
        ((ComputedFolder)this.job).scheduleBuild(0, (Cause)new TimerTrigger.TimerTriggerCause());
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof ComputedFolder;
        }

        public String getDisplayName() {
            return "Periodically if not otherwise run";
        }

        public ListBoxModel doFillIntervalItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("1 minute", "1m");
            model.add("2 minutes", "2m");
            model.add("5 minutes", "5m");
            model.add("10 minutes", "10m");
            model.add("15 minutes", "15m");
            model.add("20 minutes", "20m");
            model.add("25 minutes", "25m");
            model.add("30 minutes", "30m");
            model.add("1 hour", "1h");
            model.add("2 hours", "2h");
            model.add("4 hours", "4h");
            model.add("8 hours", "8h");
            model.add("12 hours", "12h");
            model.add("1 day", "1d");
            model.add("2 days", "2d");
            model.add("1 week", "7d");
            model.add("2 weeks", "14d");
            model.add("4 weeks", "28d");
            return model;
        }

        static {
            Items.XSTREAM2.addCompatibilityAlias("jenkins.branch.IndexAtLeastTrigger", PeriodicFolderTrigger.class);
        }
    }
}

