/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.relocate;

import com.cloudbees.hudson.plugins.folder.Messages;
import com.cloudbees.hudson.plugins.folder.relocate.RelocationHandler;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicReference;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Restricted(value={NoExternalUse.class})
public class RelocationAction
implements Action {
    public static final Permission RELOCATE = new Permission(Item.PERMISSIONS, "Move", Messages._RelocateAction_permission_desc(), Permission.CREATE, PermissionScope.ITEM);
    private final Item item;

    public RelocationAction(Item item) {
        this.item = item;
    }

    public String getIconFileName() {
        for (RelocationHandler handler : Jenkins.getInstance().getExtensionList(RelocationHandler.class)) {
            if (handler.applicability(this.item) != RelocationHandler.HandlingMode.HANDLE) continue;
            return "/plugin/cloudbees-folder/images/24x24/move.png";
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.RelocateAction_displayName();
    }

    public String getUrlName() {
        return "move";
    }

    public Item getItem() {
        return this.item;
    }

    public ItemGroup<?> getItemParent() {
        return this.item.getParent();
    }

    public Collection<ItemGroup<?>> getDestinations() {
        LinkedHashSet result = new LinkedHashSet();
        for (RelocationHandler handler : Jenkins.getInstance().getExtensionList(RelocationHandler.class)) {
            if (handler.applicability(this.item) != RelocationHandler.HandlingMode.HANDLE) continue;
            result.addAll(handler.validDestinations(this.item));
        }
        return result;
    }

    @RequirePOST
    public HttpResponse doMove(StaplerRequest req, @QueryParameter String destination) throws IOException, InterruptedException {
        this.item.checkPermission(RELOCATE);
        ItemGroup<?> dest = null;
        for (ItemGroup<?> itemGroup : this.getDestinations()) {
            if (!("/" + itemGroup.getFullName()).equals(destination)) continue;
            dest = itemGroup;
            break;
        }
        if (dest == null || dest == this.item.getParent()) {
            return HttpResponses.forwardToPreviousPage();
        }
        ArrayList<RelocationHandler> chain = new ArrayList<RelocationHandler>();
        for (RelocationHandler handler : Jenkins.getInstance().getExtensionList(RelocationHandler.class)) {
            if (handler.applicability(this.item) == RelocationHandler.HandlingMode.SKIP) continue;
            chain.add(handler);
        }
        if (chain.isEmpty()) {
            return new Failure("no known way to handle " + this.item);
        }
        HttpResponse response = ((RelocationHandler)chain.get(0)).handle(this.item, dest, new AtomicReference<Item>(), chain.subList(1, chain.size()));
        if (response != null) {
            return response;
        }
        return HttpResponses.forwardToPreviousPage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class TransientActionFactoryImpl
    extends TransientActionFactory<Item> {
        public Class<Item> type() {
            return Item.class;
        }

        public Collection<? extends Action> createFor(Item target) {
            return Collections.singleton(new RelocationAction(target));
        }

        static {
            RELOCATE.getId();
        }
    }
}

