/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.properties;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.FolderProperty;
import com.cloudbees.hudson.plugins.folder.FolderPropertyDescriptor;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Run;
import hudson.security.AccessControlled;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.security.SidACL;
import hudson.util.FormValidation;
import hudson.util.RobustReflectionConverter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.Sid;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationMatrixProperty
extends FolderProperty<Folder> {
    private transient SidACL acl = new AclImpl();
    private final Map<Permission, Set<String>> grantedPermissions = new HashMap<Permission, Set<String>>();
    private Set<String> sids = new HashSet<String>();

    protected AuthorizationMatrixProperty() {
    }

    public AuthorizationMatrixProperty(Map<Permission, Set<String>> grantedPermissions) {
        for (Map.Entry<Permission, Set<String>> e : grantedPermissions.entrySet()) {
            this.grantedPermissions.put(e.getKey(), new HashSet(e.getValue()));
        }
    }

    public Set<String> getGroups() {
        return this.sids;
    }

    public List<String> getAllSIDs() {
        HashSet<String> r = new HashSet<String>();
        for (Set<String> set : this.grantedPermissions.values()) {
            r.addAll(set);
        }
        r.remove("anonymous");
        Object[] data = r.toArray(new String[r.size()]);
        Arrays.sort(data);
        return Arrays.asList(data);
    }

    public Map<Permission, Set<String>> getGrantedPermissions() {
        return Collections.unmodifiableMap(this.grantedPermissions);
    }

    protected void add(Permission p, String sid) {
        Set<String> set = this.grantedPermissions.get(p);
        if (set == null) {
            set = new HashSet<String>();
            this.grantedPermissions.put(p, set);
        }
        set.add(sid);
        this.sids.add(sid);
    }

    public SidACL getACL() {
        return this.acl;
    }

    public boolean hasPermission(String sid, Permission p) {
        while (p != null) {
            Set<String> set = this.grantedPermissions.get(p);
            if (set != null && set.contains(sid)) {
                return true;
            }
            p = p.impliedBy;
        }
        return false;
    }

    public boolean hasExplicitPermission(String sid, Permission p) {
        Set<String> set = this.grantedPermissions.get(p);
        return set != null && set.contains(sid);
    }

    private void add(String shortForm) {
        int idx = shortForm.indexOf(58);
        Permission p = Permission.fromId((String)shortForm.substring(0, idx));
        if (p == null) {
            throw new IllegalArgumentException("Failed to parse '" + shortForm + "' --- no such permission");
        }
        this.add(p, shortForm.substring(idx + 1));
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == AuthorizationMatrixProperty.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            AuthorizationMatrixProperty amp = (AuthorizationMatrixProperty)((Object)source);
            for (Map.Entry e : amp.grantedPermissions.entrySet()) {
                String p = ((Permission)e.getKey()).getId();
                for (String sid : (Set)e.getValue()) {
                    writer.startNode("permission");
                    writer.setValue(p + ':' + sid);
                    writer.endNode();
                }
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            AuthorizationMatrixProperty as = new AuthorizationMatrixProperty();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                try {
                    as.add(reader.getValue());
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(AuthorizationMatrixProperty.class.getName()).log(Level.WARNING, "Skipping a non-existent permission", ex);
                    RobustReflectionConverter.addErrorInContext((UnmarshallingContext)context, (Throwable)ex);
                }
                reader.moveUp();
            }
            return as;
        }
    }

    private final class AclImpl
    extends SidACL {
        private AclImpl() {
        }

        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Because that is the way this SPI works")
        protected Boolean hasPermission(Sid sid, Permission p) {
            if (AuthorizationMatrixProperty.this.hasPermission(this.toString(sid), p)) {
                return true;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends FolderPropertyDescriptor {
        public FolderProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if ((formData = formData.getJSONObject("useProjectSecurity")).isNullObject()) {
                return null;
            }
            AuthorizationMatrixProperty amp = new AuthorizationMatrixProperty();
            for (Map.Entry r : formData.getJSONObject("data").entrySet()) {
                String sid = (String)r.getKey();
                if (!(r.getValue() instanceof JSONObject)) continue;
                for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                    if (!((Boolean)e.getValue()).booleanValue()) continue;
                    Permission p = Permission.fromId((String)((String)e.getKey()));
                    amp.add(p, sid);
                }
            }
            return amp;
        }

        @Override
        public boolean isApplicable(Class<? extends Folder> containerType) {
            try {
                return Hudson.getInstance().getAuthorizationStrategy() instanceof ProjectMatrixAuthorizationStrategy;
            }
            catch (NoClassDefFoundError x) {
                return false;
            }
        }

        public String getDisplayName() {
            return "Authorization Matrix";
        }

        public List<PermissionGroup> getAllGroups() {
            return Arrays.asList(PermissionGroup.get(Item.class), PermissionGroup.get(Run.class));
        }

        public boolean showPermission(Permission p) {
            return p.getEnabled();
        }

        public FormValidation doCheckName(@AncestorInPath Folder folder, @QueryParameter String value) throws IOException, ServletException {
            return GlobalMatrixAuthorizationStrategy.DESCRIPTOR.doCheckName_(value, (AccessControlled)folder, AbstractProject.CONFIGURE);
        }
    }
}

