/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.relocate;

import com.cloudbees.hudson.plugins.folder.Messages;
import com.cloudbees.hudson.plugins.folder.relocate.RelocationUI;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.TransientActionFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerFallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Restricted(value={NoExternalUse.class})
public class RelocationAction
implements Action,
StaplerFallback {
    public static final Permission RELOCATE = new Permission(Item.PERMISSIONS, "Move", Messages._RelocateAction_permission_desc(), Permission.CREATE, PermissionScope.ITEM);
    private final Item item;
    @CheckForNull
    private final RelocationUI ui;

    public RelocationAction(@Nonnull Item item) {
        this.item = item;
        this.ui = RelocationUI.for_(item);
    }

    public RelocationAction(@Nonnull Item item, @Nonnull RelocationUI ui) {
        this.item = item;
        this.ui = ui;
    }

    public String getIconFileName() {
        return !this.item.hasPermission(RELOCATE) || this.ui == null || !this.ui.isAvailable(this.item) ? null : this.ui.getIconFileName();
    }

    public String getDisplayName() {
        return this.ui == null ? null : this.ui.getDisplayName();
    }

    public String getUrlName() {
        return this.ui == null ? null : this.ui.getUrlName();
    }

    public Item getItem() {
        return this.item;
    }

    @CheckForNull
    public RelocationUI getUi() {
        return this.ui;
    }

    public Object getStaplerFallback() {
        return this.ui;
    }

    public ItemGroup<?> getItemParent() {
        return this.item.getParent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="ensure loaded eagerly")
    public static class TransientActionFactoryImpl
    extends TransientActionFactory<Item> {
        public Class<Item> type() {
            return Item.class;
        }

        public Collection<? extends Action> createFor(@Nonnull Item target) {
            return Collections.singleton(new RelocationAction(target));
        }

        static {
            RELOCATE.getId();
        }
    }
}

