/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.health;

import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetric;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import com.cloudbees.hudson.plugins.folder.health.Messages;
import hudson.Extension;
import hudson.model.HealthReport;
import hudson.model.Item;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class WorstChildHealthMetric
extends FolderHealthMetric {
    @DataBoundConstructor
    public WorstChildHealthMetric() {
    }

    public FolderHealthMetric.Reporter reporter() {
        return new ReporterImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReporterImpl
    implements FolderHealthMetric.Reporter {
        HealthReport worst = null;

        private ReporterImpl() {
        }

        @Override
        public void observe(Item item) {
            HealthReport report = FolderHealthMetric.getHealthReport(item);
            if (report != null && (this.worst == null || report.getScore() < this.worst.getScore())) {
                this.worst = new HealthReport(report.getScore(), report.getIconUrl(), Messages._Folder_HealthWrap(item.getFullDisplayName(), report.getLocalizableDescription()));
            }
        }

        @Override
        public List<HealthReport> report() {
            return this.worst != null && this.worst.getScore() < 100 ? Collections.singletonList(this.worst) : Collections.emptyList();
        }
    }

    @Extension(ordinal=400.0)
    public static class DescriptorImpl
    extends FolderHealthMetricDescriptor {
        public String getDisplayName() {
            return "Child item with worst health";
        }

        public FolderHealthMetric createDefault() {
            return new WorstChildHealthMetric();
        }
    }
}

