/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.WebhookConfiguration;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import hudson.triggers.SafeTimerTask;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;

@Extension
public class WebhookAutoRegisterListener
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(WebhookAutoRegisterListener.class.getName());
    private static ExecutorService executorService;

    public void onCreated(Item item) {
        if (!this.isApplicable(item)) {
            return;
        }
        this.registerHooksAsync((SCMSourceOwner)item);
    }

    public void onDeleted(Item item) {
        if (!this.isApplicable(item)) {
            return;
        }
        this.removeHooksAsync((SCMSourceOwner)item);
    }

    public void onUpdated(Item item) {
        if (!this.isApplicable(item)) {
            return;
        }
        this.registerHooksAsync((SCMSourceOwner)item);
    }

    private boolean isApplicable(Item item) {
        if (!(item instanceof SCMSourceOwner)) {
            return false;
        }
        for (SCMSource source : ((SCMSourceOwner)item).getSCMSources()) {
            if (!(source instanceof BitbucketSCMSource)) continue;
            return true;
        }
        return false;
    }

    private void registerHooksAsync(final SCMSourceOwner owner) {
        WebhookAutoRegisterListener.getExecutorService().submit((Runnable)new SafeTimerTask(){

            public void doRun() {
                try {
                    WebhookAutoRegisterListener.this.registerHooks(owner);
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Could not register hooks for " + owner.getFullName(), e);
                }
            }
        });
    }

    private void removeHooksAsync(final SCMSourceOwner owner) {
        WebhookAutoRegisterListener.getExecutorService().submit((Runnable)new SafeTimerTask(){

            public void doRun() {
                try {
                    WebhookAutoRegisterListener.this.removeHooks(owner);
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Could not deregister hooks for " + owner.getFullName(), e);
                }
            }
        });
    }

    private synchronized void registerHooks(SCMSourceOwner owner) throws IOException, InterruptedException {
        List<BitbucketSCMSource> sources = this.getBitbucketSCMSources(owner);
        if (sources.isEmpty()) {
            return;
        }
        block4: for (BitbucketSCMSource source : sources) {
            String rootUrl = source.getEndpointJenkinsRootUrl();
            if (!rootUrl.startsWith("http://localhost") && !rootUrl.startsWith("http://unconfigured-jenkins-location")) {
                this.registerHook(source);
                continue;
            }
            switch (((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).webhookRegistration()) {
                case DISABLE: {
                    continue block4;
                }
                case SYSTEM: {
                    AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(source.getServerUrl());
                    if (endpoint != null && endpoint.isManageHooks()) break;
                    continue block4;
                }
            }
            LOGGER.log(Level.WARNING, "Can not register hook. Jenkins root URL is not valid: {0}", rootUrl);
        }
    }

    private void registerHook(BitbucketSCMSource source) throws IOException, InterruptedException {
        BitbucketApi bitbucket = this.bitbucketApiFor(source);
        if (bitbucket == null) {
            return;
        }
        String hookReceiverUrl = source.getEndpointJenkinsRootUrl() + "bitbucket-scmsource-hook/notify";
        BitbucketWebHook existingHook = bitbucket.getWebHooks().stream().filter(hook -> hook.getUrl() != null && hook.getUrl().startsWith(hookReceiverUrl)).findFirst().orElse(null);
        WebhookConfiguration hookConfig = ((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).webhookConfiguration();
        if (existingHook == null) {
            LOGGER.log(Level.INFO, "Registering hook for {0}/{1}", new Object[]{source.getRepoOwner(), source.getRepository()});
            bitbucket.registerCommitWebHook(hookConfig.getHook(source));
        } else if (hookConfig.updateHook(existingHook, source)) {
            LOGGER.log(Level.INFO, "Updating hook for {0}/{1}", new Object[]{source.getRepoOwner(), source.getRepository()});
            bitbucket.updateCommitWebHook(existingHook);
        }
    }

    private void removeHooks(SCMSourceOwner owner) throws IOException, InterruptedException {
        List<BitbucketSCMSource> sources = this.getBitbucketSCMSources(owner);
        for (BitbucketSCMSource source : sources) {
            BitbucketApi bitbucket = this.bitbucketApiFor(source);
            if (bitbucket == null) continue;
            List<? extends BitbucketWebHook> existent = bitbucket.getWebHooks();
            BitbucketWebHook hook = null;
            for (BitbucketWebHook bitbucketWebHook : existent) {
                if (!bitbucketWebHook.getUrl().startsWith(source.getEndpointJenkinsRootUrl() + "bitbucket-scmsource-hook/notify")) continue;
                hook = bitbucketWebHook;
                break;
            }
            if (hook != null && !this.isUsedSomewhereElse(owner, source.getRepoOwner(), source.getRepository())) {
                LOGGER.log(Level.INFO, "Removing hook for {0}/{1}", new Object[]{source.getRepoOwner(), source.getRepository()});
                bitbucket.removeCommitWebHook(hook);
                continue;
            }
            LOGGER.log(Level.FINE, "NOT removing hook for {0}/{1} because does not exists or its used in other project", new Object[]{source.getRepoOwner(), source.getRepository()});
        }
    }

    private BitbucketApi bitbucketApiFor(BitbucketSCMSource source) {
        switch (((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).webhookRegistration()) {
            case DISABLE: {
                return null;
            }
            case SYSTEM: {
                AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(source.getServerUrl());
                return endpoint == null || !endpoint.isManageHooks() ? null : BitbucketApiFactory.newInstance(endpoint.getServerUrl(), endpoint.authenticator(), source.getRepoOwner(), source.getRepository());
            }
            case ITEM: {
                return source.buildBitbucketClient();
            }
        }
        return null;
    }

    private boolean isUsedSomewhereElse(SCMSourceOwner owner, String repoOwner, String repoName) {
        Iterable all = SCMSourceOwners.all();
        for (SCMSourceOwner other : all) {
            if (owner == other) continue;
            for (SCMSource otherSource : other.getSCMSources()) {
                if (!(otherSource instanceof BitbucketSCMSource) || !((BitbucketSCMSource)otherSource).getRepoOwner().equals(repoOwner) || !((BitbucketSCMSource)otherSource).getRepository().equals(repoName)) continue;
                return true;
            }
        }
        return false;
    }

    private List<BitbucketSCMSource> getBitbucketSCMSources(SCMSourceOwner owner) {
        ArrayList<BitbucketSCMSource> sources = new ArrayList<BitbucketSCMSource>();
        for (SCMSource source : owner.getSCMSources()) {
            if (!(source instanceof BitbucketSCMSource)) continue;
            sources.add((BitbucketSCMSource)source);
        }
        return sources;
    }

    private static synchronized ExecutorService getExecutorService() {
        if (executorService == null) {
            executorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), WebhookAutoRegisterListener.class.getName()));
        }
        return executorService;
    }
}

