/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMNavigator;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;

abstract class NativeServerHeadEvent<P>
extends SCMHeadEvent<P> {
    private static final Logger LOGGER = Logger.getLogger(NativeServerHeadEvent.class.getName());
    @NonNull
    private final String serverUrl;

    NativeServerHeadEvent(String serverUrl, SCMEvent.Type type, P payload, String origin) {
        super(type, payload, origin);
        this.serverUrl = serverUrl;
    }

    @NonNull
    public String getSourceName() {
        return this.getRepository().getRepositoryName();
    }

    public boolean isMatch(@NonNull SCMNavigator navigator) {
        if (!(navigator instanceof BitbucketSCMNavigator)) {
            return false;
        }
        BitbucketSCMNavigator bbNav = (BitbucketSCMNavigator)navigator;
        return this.isServerUrlMatch(bbNav.getServerUrl()) && bbNav.getRepoOwner().equalsIgnoreCase(this.getRepository().getOwnerName());
    }

    public boolean isMatch(@NonNull SCM scm) {
        return false;
    }

    @NonNull
    public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
        BitbucketSCMSource src = this.getMatchingBitbucketSource(source);
        return src == null ? Collections.emptyMap() : this.heads(src);
    }

    protected abstract BitbucketServerRepository getRepository();

    @NonNull
    protected abstract Map<SCMHead, SCMRevision> heads(@NonNull BitbucketSCMSource var1);

    protected boolean isServerUrlMatch(String serverUrl) {
        if (serverUrl == null || "https://bitbucket.org".equals(serverUrl)) {
            return false;
        }
        return serverUrl.equals(this.serverUrl);
    }

    protected boolean eventMatchesRepo(BitbucketSCMSource source) {
        BitbucketServerRepository repo = this.getRepository();
        return repo.getOwnerName().equalsIgnoreCase(source.getRepoOwner()) && repo.getRepositoryName().equalsIgnoreCase(source.getRepository());
    }

    protected BitbucketSCMSourceContext contextOf(BitbucketSCMSource source) {
        return (BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits());
    }

    private BitbucketSCMSource getMatchingBitbucketSource(SCMSource source) {
        if (!(source instanceof BitbucketSCMSource)) {
            return null;
        }
        BitbucketSCMSource src = (BitbucketSCMSource)source;
        if (!this.isServerUrlMatch(src.getServerUrl())) {
            return null;
        }
        return src;
    }
}

