/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client.repository;

import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import jenkins.scm.api.SCMFile;

public class BitbucketRepositorySource {
    private final String path;
    private final String type;
    private final String hash;
    private final List<String> attributes;

    @JsonCreator
    public BitbucketRepositorySource(@JsonProperty(value="path") String path, @JsonProperty(value="type") String type, @JsonProperty(value="attributes") List<String> attributes, @JsonProperty(value="commit") Map commit) {
        this.path = path;
        this.type = type;
        this.attributes = attributes;
        this.hash = (String)commit.get("hash");
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="attributes")
    public List<String> getAttributes() {
        return this.attributes;
    }

    @JsonIgnore
    public String getHash() {
        return this.hash;
    }

    @JsonIgnore
    public boolean isDirectory() {
        return this.type.equals("commit_directory");
    }

    public BitbucketSCMFile toBitbucketScmFile(BitbucketSCMFile parent) {
        SCMFile.Type fileType;
        if (this.isDirectory()) {
            fileType = SCMFile.Type.DIRECTORY;
        } else {
            fileType = SCMFile.Type.REGULAR_FILE;
            for (String attribute : this.getAttributes()) {
                if (attribute.equals("link")) {
                    fileType = SCMFile.Type.LINK;
                    continue;
                }
                if (!attribute.equals("subrepository")) continue;
                fileType = SCMFile.Type.OTHER;
            }
        }
        return new BitbucketSCMFile(parent, this.path, fileType, this.hash);
    }
}

