/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestDestination;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudBranch;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudCommit;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketCloudRepository;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Date;

public class BitbucketPullRequestValueDestination
implements BitbucketPullRequestDestination {
    private BitbucketCloudRepository repository;
    private BitbucketCloudBranch branch;
    private BitbucketCloudCommit commit;

    @JsonCreator
    public BitbucketPullRequestValueDestination(@JsonProperty(value="repository") @NonNull BitbucketCloudRepository repository, @JsonProperty(value="branch") BitbucketCloudBranch branch, @JsonProperty(value="commit") @CheckForNull BitbucketCloudCommit commit) {
        this.repository = repository;
        this.branch = branch;
        this.commit = commit;
        if (this.branch != null && this.commit != null) {
            this.branch.setRawNode(commit.getHash());
        }
    }

    @Override
    public BitbucketCloudRepository getRepository() {
        return this.repository;
    }

    public void setRepository(BitbucketCloudRepository repository) {
        this.repository = repository;
    }

    @Override
    @CheckForNull
    public BitbucketCloudBranch getBranch() {
        return this.branch;
    }

    public void setBranch(BitbucketCloudBranch branch) {
        this.branch = branch;
    }

    @Override
    @CheckForNull
    public BitbucketCommit getCommit() {
        if (this.branch != null && this.commit != null) {
            if (this.commit.getAuthor() == null) {
                this.commit.setAuthor(this.branch.getAuthor());
            }
            if (this.commit.getMessage() == null) {
                this.commit.setMessage(this.branch.getMessage());
            }
            if (this.commit.getDateMillis() == 0L) {
                this.commit.setDate(new StdDateFormat().format(new Date(this.branch.getDateMillis())));
            }
        }
        return this.commit;
    }

    public void setCommit(BitbucketCloudCommit commit) {
        this.commit = commit;
    }
}

