/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.avatars.AvatarCache;
import com.cloudbees.jenkins.plugins.bitbucket.avatars.AvatarCacheSource;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.scm.api.metadata.AvatarMetadataAction;

public class BitbucketTeamMetadataAction
extends AvatarMetadataAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BitbucketTeamMetadataAction.class.getName());
    private final BitbucketAvatarCacheSource avatarSource;

    public BitbucketTeamMetadataAction(String serverUrl, StandardCredentials credentials, String team) {
        this.avatarSource = new BitbucketAvatarCacheSource(serverUrl, credentials, team);
    }

    public String getAvatarImageOf(String size) {
        return this.avatarSource == null ? this.avatarIconClassNameImageOf(this.getAvatarIconClassName(), size) : AvatarCache.buildUrl(this.avatarSource, size);
    }

    public String getAvatarIconClassName() {
        return this.avatarSource == null ? "icon-bitbucket-logo" : null;
    }

    public String getAvatarDescription() {
        return Messages.BitbucketTeamMetadataAction_IconDescription();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BitbucketTeamMetadataAction that = (BitbucketTeamMetadataAction)((Object)o);
        if (this.avatarSource == null) {
            return that.avatarSource == null;
        }
        return this.avatarSource.equals(that.avatarSource);
    }

    public int hashCode() {
        return Objects.hashCode(this.avatarSource);
    }

    public String toString() {
        return "BitbucketTeamMetadataAction{, avatarSource='" + this.avatarSource + '\'' + '}';
    }

    public static class BitbucketAvatarCacheSource
    implements AvatarCacheSource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String serverUrl;
        private final StandardCredentials credentials;
        private final String repoOwner;

        public BitbucketAvatarCacheSource(String serverUrl, StandardCredentials credentials, String repoOwner) {
            this.serverUrl = serverUrl;
            this.credentials = credentials;
            this.repoOwner = repoOwner;
            LOGGER.log(Level.INFO, "Created: {0}", this.toString());
        }

        @Override
        public AvatarCacheSource.AvatarImage fetch() {
            BitbucketAuthenticator authenticator = (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.serverUrl), (Credentials)this.credentials);
            BitbucketApi bitbucket = BitbucketApiFactory.newInstance(this.serverUrl, authenticator, this.repoOwner, null);
            try {
                return bitbucket.getTeamAvatar();
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "IOException: " + e.getMessage(), e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.INFO, "InterruptedException: " + e.getMessage(), e);
            }
            return null;
        }

        @Override
        public String hashKey() {
            return "" + this.serverUrl + "::" + this.repoOwner + "::" + (this.credentials != null ? this.credentials.getId() : "");
        }

        @Override
        public boolean canFetch() {
            return this.serverUrl != null && this.repoOwner != null && !this.serverUrl.trim().isEmpty() && !this.repoOwner.trim().isEmpty();
        }

        public int hashCode() {
            return Objects.hashCode(this.hashKey());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BitbucketAvatarCacheSource that = (BitbucketAvatarCacheSource)o;
            return this.hashKey().equals(that.hashKey());
        }

        public String toString() {
            return "BitbucketAvatarSource(" + this.hashKey() + ")";
        }
    }
}

