/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

class BitbucketCredentials {
    private BitbucketCredentials() {
        throw new IllegalAccessError("Utility class");
    }

    @CheckForNull
    static <T extends StandardCredentials> T lookupCredentials(@CheckForNull String serverUrl, @CheckForNull SCMSourceOwner context, @CheckForNull String id, @NonNull Class<T> type) {
        if (StringUtils.isNotBlank((String)id) && context != null) {
            return (T)((StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(type, (Item)context, (Authentication)(context instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)id), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(type)})})));
        }
        return null;
    }

    static ListBoxModel fillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl) {
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeEmptyValue();
        result.includeMatchingAs(context instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, (Item)context, StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(serverUrl)));
        return result;
    }

    static FormValidation checkCredentialsId(@AncestorInPath @CheckForNull SCMSourceOwner context, @QueryParameter String value, @QueryParameter String serverUrl) {
        if (!value.isEmpty()) {
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)value), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(serverUrl))})) != null) {
                return FormValidation.warning((String)"A certificate was selected. You will likely need to configure Checkout over SSH.");
            }
            return FormValidation.ok();
        }
        return FormValidation.warning((String)"Credentials are required for build notifications");
    }
}

