/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.plugins.sparknotify.workflow;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.jenkins.plugins.sparknotify.SparkMessage;
import com.jenkins.plugins.sparknotify.SparkMessageType;
import com.jenkins.plugins.sparknotify.SparkNotifier;
import com.jenkins.plugins.sparknotify.SparkNotifyException;
import com.jenkins.plugins.sparknotify.SparkSpace;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.acegisecurity.Authentication;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SparkSendStep
extends AbstractStepImpl {
    private final String message;
    private String messageType;
    private final String credentialsId;
    private List<SparkSpace> spaceList;
    private boolean disable;
    private boolean failOnError;

    public String getMessage() {
        return this.message;
    }

    public List<SparkSpace> getSpaceList() {
        if (this.spaceList == null) {
            this.spaceList = new ArrayList<SparkSpace>();
        }
        return this.spaceList;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getMessageType() {
        return this.messageType;
    }

    @DataBoundSetter
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public boolean isDisable() {
        return this.disable;
    }

    @DataBoundSetter
    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @DataBoundConstructor
    public SparkSendStep(String message, List<SparkSpace> spaceList, String credentialsId) {
        this.message = message;
        this.spaceList = spaceList;
        this.credentialsId = credentialsId;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(SparkSendStepExecution.class);
        }

        public String getFunctionName() {
            return "sparkSend";
        }

        public String getDisplayName() {
            return "Send spark message";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.instanceOf(StringCredentials.class), (Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }

        public ListBoxModel doFillMessageTypeItems(@QueryParameter String messageType) {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("text", "text", messageType.matches("text")), new ListBoxModel.Option("markdown", "markdown", messageType.matches("markdown")), new ListBoxModel.Option("html", "html", messageType.matches("html"))});
        }

        public FormValidation doMessageCheck(@QueryParameter String message) {
            if (SparkMessage.isMessageValid(message)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Message cannot be null");
        }

        public FormValidation doSpaceIdCheck(@QueryParameter String spaceId) {
            if (SparkMessage.isRoomIdValid(spaceId)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid spaceId; see help message");
        }
    }

    public static class SparkSendStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        transient SparkSendStep step;
        @StepContextParameter
        transient EnvVars envVars;
        @StepContextParameter
        transient TaskListener listener;

        protected Void run() throws IOException, InterruptedException {
            if (this.step.disable) {
                this.listener.getLogger().println("Spark Notifier Plugin Disabled!");
                return null;
            }
            if (!SparkMessage.isMessageValid(this.step.getMessage())) {
                String error = "Skipping spark notifications because no message was defined";
                if (this.step.failOnError) {
                    throw new AbortException(error);
                }
                this.listener.getLogger().println(error);
                return null;
            }
            if (CollectionUtils.isEmpty((Collection)this.step.spaceList)) {
                String error = "Skipping spark notifications because no spaces were defined";
                if (this.step.failOnError) {
                    throw new AbortException(error);
                }
                this.listener.getLogger().println(error);
                return null;
            }
            if (StringUtils.isEmpty((String)this.step.messageType)) {
                this.step.messageType = "text";
            }
            SparkMessageType sparkMessageType = SparkMessageType.valueOf(this.step.messageType.toUpperCase());
            SparkNotifier notifier = new SparkNotifier(this.getCredentials(this.step.credentialsId, (Run)this.getContext().get(Run.class)), this.envVars);
            for (int i = 0; i < this.step.spaceList.size(); ++i) {
                String error;
                this.listener.getLogger().println("Sending message to spark space: " + ((SparkSpace)((Object)this.step.spaceList.get(i))).getSpaceId());
                try {
                    Response response = notifier.sendMessage(((SparkSpace)((Object)this.step.spaceList.get(i))).getSpaceId(), this.step.getMessage(), sparkMessageType);
                    if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                        error = "Could not send message; HTTP response: " + response.getStatus() + "\n" + (String)response.readEntity(String.class);
                        if (this.step.failOnError) {
                            throw new AbortException(error);
                        }
                        this.listener.getLogger().println(error);
                        continue;
                    }
                    this.listener.getLogger().println("Message sent");
                    continue;
                }
                catch (SparkNotifyException e) {
                    if (this.step.failOnError) {
                        throw new AbortException(e.getMessage());
                    }
                    this.listener.getLogger().println(e.getMessage());
                    continue;
                }
                catch (SocketException e) {
                    error = "Could not send message because spark server did not provide a response; this is likely intermittent";
                    if (this.step.failOnError) {
                        throw new AbortException(error);
                    }
                    this.listener.getLogger().println(error);
                    continue;
                }
                catch (RuntimeException e) {
                    error = "Could not send message because of an unknown issue; please file an issue\n" + e.getMessage();
                    if (this.step.failOnError) {
                        throw new AbortException(error);
                    }
                    this.listener.getLogger().println(error);
                }
            }
            return null;
        }

        private Credentials getCredentials(String credentialsId, Run<?, ?> run) {
            return CredentialsProvider.findCredentialById((String)credentialsId, StringCredentials.class, run, (DomainRequirement[])new DomainRequirement[0]);
        }
    }
}

