/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.plugins.sparknotify;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.jenkins.plugins.sparknotify.SparkMessage;
import com.jenkins.plugins.sparknotify.SparkMessageType;
import com.jenkins.plugins.sparknotify.SparkNotifier;
import com.jenkins.plugins.sparknotify.SparkNotifyException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SparkNotifyPostBuilder
extends Recorder {
    private static final String JOB_FAILURE = "FAILURE";
    private static final String JOB_SUCCESS = "SUCCESS";
    private static final String JOB_ABORTED = "ABORTED";
    private static final String JOB_UNSTABLE = "UNSTABLE";
    private List<SparkRoom> roomList;
    private final boolean disable;
    private final boolean skipOnFailure;
    private final boolean skipOnSuccess;
    private final boolean skipOnAborted;
    private final boolean skipOnUnstable;
    private String message;
    private String messageType;
    private String messageContent;
    private String credentialsId;

    @DataBoundConstructor
    public SparkNotifyPostBuilder(boolean disable, boolean skipOnFailure, boolean skipOnSuccess, boolean skipOnAborted, boolean skipOnUnstable, String messageContent, String messageType, List<SparkRoom> roomList, String credentialsId) {
        this.disable = disable;
        this.skipOnFailure = skipOnFailure;
        this.skipOnSuccess = skipOnSuccess;
        this.skipOnAborted = skipOnAborted;
        this.skipOnUnstable = skipOnUnstable;
        this.messageContent = messageContent;
        this.messageType = messageType;
        this.roomList = roomList;
        this.credentialsId = credentialsId;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    @DataBoundSetter
    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public boolean isSkipOnFailure() {
        return this.skipOnFailure;
    }

    public boolean isSkipOnSuccess() {
        return this.skipOnSuccess;
    }

    public boolean isSkipOnAborted() {
        return this.skipOnAborted;
    }

    public boolean isSkipOnUnstable() {
        return this.skipOnUnstable;
    }

    public List<SparkRoom> getRoomList() {
        if (this.roomList == null) {
            this.roomList = new ArrayList<SparkRoom>();
        }
        return this.roomList;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.disable) {
            listener.getLogger().println("Spark Notify Plugin Disabled!");
            return true;
        }
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        this.message = this.getMessageContent();
        if (!SparkMessage.isMessageValid(this.message)) {
            listener.getLogger().println("Skipping spark notifications because no message was defined");
            return true;
        }
        String result = build.getResult().toString();
        if (result != null && !result.toString().isEmpty()) {
            this.message = this.message.replace("${BUILD_RESULT}", result);
        } else {
            listener.getLogger().println("Could not get result");
            result = "";
        }
        if (this.skipOnSuccess && result.equals(JOB_SUCCESS)) {
            listener.getLogger().println("Skipping spark notifications because job was successful");
            return true;
        }
        if (this.skipOnFailure && result.equals(JOB_FAILURE)) {
            listener.getLogger().println("Skipping spark notifications because job failed");
            return true;
        }
        if (this.skipOnAborted && result.equals(JOB_ABORTED)) {
            listener.getLogger().println("Skipping spark notifications because job was aborted");
            return true;
        }
        if (this.skipOnUnstable && result.equals(JOB_UNSTABLE)) {
            listener.getLogger().println("Skipping spark notifications because job is unstable");
            return true;
        }
        if (StringUtils.isEmpty((String)this.messageType)) {
            this.messageType = "text";
        }
        if (CollectionUtils.isEmpty(this.roomList)) {
            listener.getLogger().println("Skipping spark notifications because no rooms were defined");
            return true;
        }
        SparkMessageType sparkMessageType = SparkMessageType.valueOf(this.messageType.toUpperCase());
        SparkNotifier notifier = new SparkNotifier(this.getCredentials(this.credentialsId, (Run<?, ?>)build), envVars);
        for (int k = 0; k < this.roomList.size(); ++k) {
            listener.getLogger().println("Sending message to Spark Room: " + this.roomList.get(k).getRId());
            try {
                Response response = notifier.sendMessage(this.roomList.get(k).getRId(), this.message, sparkMessageType);
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    listener.getLogger().println("Could not send message; HTTP response: " + response.getStatus() + "\n" + (String)response.readEntity(String.class));
                    continue;
                }
                listener.getLogger().println("Message sent");
                continue;
            }
            catch (SocketException e) {
                listener.getLogger().println("Could not send message because ppark server did not provide a response; this is likely intermittent");
                continue;
            }
            catch (SparkNotifyException e) {
                listener.getLogger().println(e.getMessage());
                continue;
            }
            catch (RuntimeException e) {
                listener.getLogger().println("Could not send message because of an unknown issue; please file an issue\n" + e.getMessage());
            }
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public SparkNotifyPostBuilderDescriptor getDescriptor() {
        return (SparkNotifyPostBuilderDescriptor)super.getDescriptor();
    }

    private Credentials getCredentials(String credentialsId, Run<?, ?> build) {
        return CredentialsProvider.findCredentialById((String)credentialsId, StringCredentials.class, build, (DomainRequirement[])new DomainRequirement[0]);
    }

    @Extension
    public static final class SparkNotifyPostBuilderDescriptor
    extends BuildStepDescriptor<Publisher> {
        public SparkNotifyPostBuilderDescriptor() {
            super(SparkNotifyPostBuilder.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return true;
        }

        public FormValidation doMessageCheck(@QueryParameter String message) {
            if (SparkMessage.isMessageValid(message)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Message cannot be null");
        }

        public FormValidation doRoomIdCheck(@QueryParameter String roomId) {
            if (SparkMessage.isRoomIdValid(roomId)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid spaceId; see help message");
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Job<?, ?> project, @QueryParameter String serverURI) {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.instanceOf(StringCredentials.class), (Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, project, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)serverURI).build()));
        }

        public ListBoxModel doFillMessageTypeItems(@QueryParameter String messageType) {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("text", "text", messageType.matches("text")), new ListBoxModel.Option("markdown", "markdown", messageType.matches("markdown")), new ListBoxModel.Option("html", "html", messageType.matches("html"))});
        }

        public String getDisplayName() {
            return "Notify Spark Rooms";
        }
    }

    @Deprecated
    public static final class SparkRoom
    extends AbstractDescribableImpl<SparkRoom> {
        private final String rName;
        private final String rId;

        public String getRName() {
            return this.rName;
        }

        public String getRId() {
            return this.rId;
        }

        @DataBoundConstructor
        public SparkRoom(String rName, String rId) {
            this.rName = rName;
            this.rId = rId;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<SparkRoom> {
            public String getDisplayName() {
                return "";
            }
        }
    }
}

