/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.plugins.sparknotify;

import com.cloudbees.plugins.credentials.Credentials;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.jenkins.plugins.sparknotify.SparkMessage;
import com.jenkins.plugins.sparknotify.SparkMessageType;
import com.jenkins.plugins.sparknotify.SparkNotifyException;
import hudson.EnvVars;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class SparkNotifier {
    private static final String SPARK_MSG_POST_URL = "https://api.ciscospark.com/v1/messages";
    private static final Pattern ENV_PATTERN_WORKFLOW = Pattern.compile("\\$\\{env\\.(.+?)\\}");
    private static final Client DEFAULT_CLIENT = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonJsonProvider.class)).build();
    private final Credentials credentials;
    private final EnvVars env;

    public SparkNotifier(Credentials credentials, EnvVars env) {
        this.credentials = credentials;
        this.env = env;
    }

    public Response sendMessage(String roomId, String message, SparkMessageType messageType) throws IOException {
        if (this.env != null) {
            message = this.replaceEnvVars(message, this.env);
        }
        SparkMessage messageData = new SparkMessage.SparkMessageBuilder().roomId(roomId).message(message).messageType(messageType).build();
        return DEFAULT_CLIENT.target(SPARK_MSG_POST_URL).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.getToken())).post(Entity.json((Object)messageData));
    }

    private String getToken() throws SparkNotifyException {
        if (this.credentials == null) {
            throw new SparkNotifyException("No credentials found");
        }
        if (this.credentials instanceof StringCredentials) {
            StringCredentials tokenCredential = (StringCredentials)this.credentials;
            String token = tokenCredential.getSecret().getPlainText();
            if (token == null || token.isEmpty()) {
                throw new SparkNotifyException("Token cannot be null");
            }
            return token;
        }
        throw new SparkNotifyException("Invalid credential type; only use 'Secret text' (token)");
    }

    private String replaceEnvVars(String message, EnvVars env) {
        Matcher workflowMatcher = ENV_PATTERN_WORKFLOW.matcher(message);
        while (workflowMatcher.find()) {
            String var = workflowMatcher.group(1);
            message = message.replace("${env." + var + "}", env.get(var, ""));
        }
        return env.expand(message);
    }
}

