/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.plugins.sparknotify;

import com.jenkins.plugins.sparknotify.SparkMessageType;
import com.jenkins.plugins.sparknotify.SparkNotifyException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;

public class SparkMessage {
    private static final String ROOM_ID_PREFIX = "ciscospark://us/ROOM/";
    private String roomId;
    private String text;
    private String markdown;
    private String html;

    public String getRoomId() {
        return this.roomId;
    }

    public String getText() {
        return this.text;
    }

    public String getHtml() {
        return this.html;
    }

    public String getMarkdown() {
        return this.markdown;
    }

    private void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    private void setMessage(String message, SparkMessageType messageType) throws SparkNotifyException {
        switch (messageType) {
            case TEXT: {
                this.text = message;
                break;
            }
            case MARKDOWN: {
                this.markdown = message;
                break;
            }
            case HTML: {
                this.html = message;
                break;
            }
            default: {
                throw new SparkNotifyException("Could not find message type. This shouldn't happen.");
            }
        }
    }

    public static boolean isMessageValid(String message) {
        return message != null && !message.isEmpty();
    }

    public static boolean isRoomIdValid(String roomId) {
        try {
            UUID.fromString(roomId);
            return true;
        }
        catch (IllegalArgumentException e1) {
            String roomIdDecodedFull = null;
            try {
                Base64 base64 = new Base64();
                roomIdDecodedFull = new String(base64.decode(roomId), StandardCharsets.UTF_8);
                if (!roomIdDecodedFull.startsWith(ROOM_ID_PREFIX)) {
                    return false;
                }
                UUID.fromString(roomIdDecodedFull.substring(ROOM_ID_PREFIX.length() + 1));
                return true;
            }
            catch (IllegalArgumentException e2) {
                return false;
            }
        }
    }

    public static class SparkMessageBuilder {
        private String roomId;
        private String message;
        private SparkMessageType messageType;

        public SparkMessageBuilder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public SparkMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public SparkMessageBuilder messageType(SparkMessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public SparkMessage build() throws SparkNotifyException {
            SparkMessage sparkMessage = new SparkMessage();
            sparkMessage.setRoomId(this.roomId);
            sparkMessage.setMessage(this.message, this.messageType);
            return sparkMessage;
        }
    }
}

