/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.security.cas.userdetails.AbstractCasAssertionUserDetailsService;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;

public final class CasUserDetailsService
extends AbstractCasAssertionUserDetailsService {
    public static final String NON_EXISTENT_PASSWORD_VALUE = "NO_PASSWORD";
    private final List<String> attributes = new ArrayList<String>();
    private final List<String> defaultAuthorities = new ArrayList<String>();
    private boolean convertToUpperCase = true;

    protected UserDetails loadUserDetails(Assertion assertion) {
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        for (String attribute : this.attributes) {
            Object value = assertion.getPrincipal().getAttributes().get(attribute);
            if (value == null) continue;
            if (value instanceof List) {
                List list = (List)value;
                for (Object o : list) {
                    String authority = o.toString();
                    if (!StringUtils.hasText((String)authority)) continue;
                    grantedAuthorities.add(new SimpleGrantedAuthority(this.convertToUpperCase ? authority.toUpperCase() : authority));
                }
                continue;
            }
            String authority = value.toString();
            if (!StringUtils.hasText((String)authority)) continue;
            grantedAuthorities.add(new SimpleGrantedAuthority(this.convertToUpperCase ? authority.toUpperCase() : authority));
        }
        for (String authority : this.defaultAuthorities) {
            grantedAuthorities.add(new SimpleGrantedAuthority(authority));
        }
        return new User(assertion.getPrincipal().getName(), NON_EXISTENT_PASSWORD_VALUE, true, true, true, true, grantedAuthorities);
    }

    public List<String> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public void setAttributes(List<String> attributes) {
        this.attributes.clear();
        this.attributes.addAll(attributes);
    }

    public boolean isConvertToUpperCase() {
        return this.convertToUpperCase;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public List<String> getDefaultAuthorities() {
        return Collections.unmodifiableList(this.defaultAuthorities);
    }

    public void setDefaultAuthorities(List<String> defaultAuthorities) {
        this.defaultAuthorities.clear();
        this.defaultAuthorities.addAll(defaultAuthorities);
    }
}

