/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring;

import hudson.model.User;
import hudson.model.UserProperty;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public class CasEventListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    public static final String DEFAULT_FULL_NAME_ATTRIBUTE = "cn";
    public static final String DEFAULT_EMAIL_ATTRIBUTE = "mail";
    private static final Logger LOG = LoggerFactory.getLogger(CasEventListener.class);
    private String fullNameAttribute = "cn";
    private String emailAttribute = "mail";
    private Pattern placeholderPattern = Pattern.compile("\\{\\{[a-zA-Z0-9._-]+\\}\\}");

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        this.onSuccessfulAuthentication(event.getAuthentication());
    }

    public void onSuccessfulAuthentication(Authentication authentication) {
        LOG.debug("Successful authentication={}", (Object)authentication);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        if (authentication instanceof CasAuthenticationToken) {
            CasAuthenticationToken casToken = (CasAuthenticationToken)authentication;
            try {
                this.syncUserAttributes(casToken);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void syncUserAttributes(CasAuthenticationToken casToken) throws IOException {
        String email;
        if (casToken.getAssertion() == null || casToken.getAssertion().getPrincipal() == null || casToken.getAssertion().getPrincipal().getAttributes() == null) {
            return;
        }
        LOG.debug("Syncing CAS user with Jenkins user '{}'", (Object)casToken.getName());
        User user = User.getOrCreateByIdOrFullName((String)casToken.getName());
        String fullName = this.parseAttributeTemplate(casToken, this.getFullNameAttribute());
        if (StringUtils.hasText((String)fullName)) {
            LOG.debug("Setting user '{}' full name to '{}'", (Object)casToken.getName(), (Object)fullName);
            user.setFullName(fullName);
        }
        if (StringUtils.hasText((String)(email = this.parseAttributeTemplate(casToken, this.getEmailAttribute())))) {
            LOG.debug("Setting user '{}' email address to '{}'", (Object)casToken.getName(), (Object)email);
            user.addProperty((UserProperty)new Mailer.UserProperty(email));
        }
        user.save();
    }

    protected String parseAttributeTemplate(CasAuthenticationToken authToken, String attributeTemplate) {
        if (StringUtils.hasText((String)attributeTemplate)) {
            if (attributeTemplate.contains("{{")) {
                StringBuffer sb = new StringBuffer();
                Matcher m = this.placeholderPattern.matcher(attributeTemplate);
                while (m.find()) {
                    String attrName = m.group();
                    String attrValue = this.getAttributeValue(authToken, attrName.substring(2, attrName.length() - 2));
                    m.appendReplacement(sb, StringUtils.hasText((String)attrValue) ? attrValue : "");
                }
                m.appendTail(sb);
                return sb.toString();
            }
            return this.getAttributeValue(authToken, attributeTemplate);
        }
        return null;
    }

    protected String getAttributeValue(CasAuthenticationToken authToken, String attributeName) {
        Map attributes;
        Object attribute;
        if (StringUtils.hasText((String)attributeName) && (attribute = (attributes = authToken.getAssertion().getPrincipal().getAttributes()).get(attributeName)) != null) {
            if (attribute instanceof Collection) {
                return ((Collection)attribute).iterator().next().toString();
            }
            return attribute.toString();
        }
        return null;
    }

    public String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    public void setFullNameAttribute(String fullNameAttribute) {
        this.fullNameAttribute = fullNameAttribute == null ? DEFAULT_FULL_NAME_ATTRIBUTE : fullNameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute == null ? DEFAULT_EMAIL_ATTRIBUTE : emailAttribute;
    }
}

