/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.protocols;

import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.ProxyList;
import org.jasig.cas.client.validation.TicketValidator;
import org.jenkinsci.plugins.cas.CasProtocol;
import org.kohsuke.stapler.DataBoundConstructor;

public class Cas20Protocol
extends CasProtocol {
    public final Boolean proxyEnabled;
    public final Boolean proxyAllowAny;
    public final String proxyAllowList;

    @Deprecated
    public Cas20Protocol(String authoritiesAttribute, String fullNameAttribute, String emailAttribute) {
        this(authoritiesAttribute, fullNameAttribute, emailAttribute, false, true, null);
    }

    @Deprecated
    public Cas20Protocol(String authoritiesAttribute, String fullNameAttribute, String emailAttribute, Boolean proxyEnabled, Boolean proxyAllowAny, String proxyAllowList) {
        this(authoritiesAttribute, fullNameAttribute, emailAttribute, null, proxyEnabled, proxyAllowAny, proxyAllowList);
    }

    @DataBoundConstructor
    public Cas20Protocol(String authoritiesAttribute, String fullNameAttribute, String emailAttribute, String customValidationParams, Boolean proxyEnabled, Boolean proxyAllowAny, String proxyAllowList) {
        super(authoritiesAttribute, fullNameAttribute, emailAttribute, customValidationParams);
        this.proxyEnabled = proxyEnabled;
        this.proxyAllowAny = proxyAllowAny;
        this.proxyAllowList = proxyAllowList;
    }

    @Override
    public TicketValidator createTicketValidator(String casServerUrl) {
        if (this.proxyEnabled != null && this.proxyEnabled.booleanValue()) {
            Cas20ProxyTicketValidator ptv = new Cas20ProxyTicketValidator(casServerUrl);
            ptv.setCustomParameters(this.getCustomValidationParamsMap());
            ptv.setAcceptAnyProxy(this.proxyAllowAny.booleanValue());
            String[] proxyChain = StringUtils.split((String)this.proxyAllowList, (char)'\n');
            if (proxyChain != null && proxyChain.length > 0) {
                ArrayList<String[]> proxyList = new ArrayList<String[]>(1);
                proxyList.add(proxyChain);
                ptv.setAllowedProxyChains(new ProxyList(proxyList));
            }
            return ptv;
        }
        Cas20ServiceTicketValidator stv = new Cas20ServiceTicketValidator(casServerUrl);
        stv.setCustomParameters(this.getCustomValidationParamsMap());
        return stv;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<CasProtocol> {
        public String getDisplayName() {
            return "CAS 2.0";
        }
    }
}

