/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.security.ChainedServletFilter;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.util.CommonUtils;
import org.jenkinsci.plugins.cas.CasProtocol;
import org.jenkinsci.plugins.cas.Messages;
import org.jenkinsci.plugins.cas.spring.CasConfigurationContext;
import org.jenkinsci.plugins.cas.spring.security.CasRestAuthenticator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.util.UrlUtils;

public class CasSecurityRealm
extends SecurityRealm {
    public static final String DEFAULT_COMMENCE_LOGIN_URL = "securityRealm/commenceLogin";
    public static final String DEFAULT_FINISH_LOGIN_URL = "securityRealm/finishLogin";
    public static final String DEFAULT_FAILED_LOGIN_URL = "securityRealm/failedLogin";
    private static final Logger LOG = LoggerFactory.getLogger(CasSecurityRealm.class);
    public final String casServerUrl;
    public final CasProtocol casProtocol;
    public final Boolean forceRenewal;
    public final Boolean enableSingleSignOut;
    public final Boolean enableRestApi;
    public final Boolean enableLogoutRedirect;
    private transient ApplicationContext applicationContext;

    @Deprecated
    public CasSecurityRealm(String casServerUrl, CasProtocol casProtocol, Boolean forceRenewal, Boolean enableSingleSignOut) {
        this(casServerUrl, casProtocol, forceRenewal, enableSingleSignOut, false);
    }

    @Deprecated
    public CasSecurityRealm(String casServerUrl, CasProtocol casProtocol, Boolean forceRenewal, Boolean enableSingleSignOut, Boolean enableRestApi) {
        this(casServerUrl, casProtocol, forceRenewal, enableSingleSignOut, enableRestApi, true);
    }

    @DataBoundConstructor
    public CasSecurityRealm(String casServerUrl, CasProtocol casProtocol, Boolean forceRenewal, Boolean enableSingleSignOut, Boolean enableRestApi, Boolean enableLogoutRedirect) {
        this.casServerUrl = StringUtils.stripEnd((String)casServerUrl, (String)"/") + "/";
        this.casProtocol = casProtocol;
        this.forceRenewal = forceRenewal;
        this.enableSingleSignOut = enableSingleSignOut;
        this.enableRestApi = enableRestApi;
        this.enableLogoutRedirect = enableLogoutRedirect;
    }

    public static String getJenkinsUrl() {
        return Jenkins.get().getRootUrl();
    }

    public static String getJenkinsUrl(HttpServletRequest req) {
        String jenkinsUrl = CasSecurityRealm.getJenkinsUrl();
        if (jenkinsUrl == null && req != null) {
            jenkinsUrl = UrlUtils.buildFullRequestUrl((String)req.getScheme(), (String)req.getServerName(), (int)req.getServerPort(), (String)req.getContextPath(), null) + "/";
        }
        return jenkinsUrl;
    }

    public static String getFinishLoginUrl() {
        return DEFAULT_FINISH_LOGIN_URL;
    }

    public static String getFailedLoginUrl() {
        return DEFAULT_FAILED_LOGIN_URL;
    }

    public static String getServiceUrl(HttpServletRequest req, ServiceProperties serviceProperties) {
        String serviceUrl = serviceProperties.getService();
        if (serviceUrl != null && !serviceUrl.startsWith("http")) {
            serviceUrl = CasSecurityRealm.getJenkinsUrl(req) + serviceUrl;
        }
        return serviceUrl;
    }

    protected ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            LOG.debug("Creating CAS ApplicationContext");
            CasSecurityRealm casSecurityRealm = this;
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
            context.registerBean(CasSecurityRealm.class, () -> casSecurityRealm, new BeanDefinitionCustomizer[0]);
            context.registerBean(CasProtocol.class, () -> casSecurityRealm.casProtocol, new BeanDefinitionCustomizer[0]);
            context.register(new Class[]{CasConfigurationContext.class});
            context.refresh();
            this.applicationContext = context;
        }
        return this.applicationContext;
    }

    public String getLoginUrl() {
        return DEFAULT_COMMENCE_LOGIN_URL;
    }

    protected String getPostLogOutUrl2(StaplerRequest req, Authentication auth) {
        if (Boolean.TRUE.equals(this.enableLogoutRedirect)) {
            StringBuilder logoutUrlBuilder = new StringBuilder(this.casServerUrl);
            logoutUrlBuilder.append("logout?service=");
            try {
                logoutUrlBuilder.append(URLEncoder.encode(CasSecurityRealm.getJenkinsUrl(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            return logoutUrlBuilder.toString();
        }
        return super.getPostLogOutUrl2(req, auth);
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof AnonymousAuthenticationToken) {
                    return authentication;
                }
                if (authentication instanceof UsernamePasswordAuthenticationToken && Boolean.TRUE.equals(CasSecurityRealm.this.enableRestApi)) {
                    return ((CasRestAuthenticator)CasSecurityRealm.this.getApplicationContext().getBean(CasRestAuthenticator.class)).authenticate(authentication);
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        });
    }

    public Filter createFilter(FilterConfig filterConfig) {
        LOG.debug("Creating CAS authentication filter");
        Filter defaultFilter = super.createFilter(filterConfig);
        Filter casFilter = (Filter)this.getApplicationContext().getBean("casFilter", ChainedServletFilter.class);
        return new ChainedServletFilter(new Filter[]{casFilter, defaultFilter});
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            ((SessionMappingStorage)this.getApplicationContext().getBean(SessionMappingStorage.class)).removeBySessionById(session.getId());
        }
        super.doLogout(req, rsp);
    }

    public void doCommenceLogin(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        LOG.debug("Redirecting to CAS for authentication");
        ((CasAuthenticationEntryPoint)this.getApplicationContext().getBean(CasAuthenticationEntryPoint.class)).commence((HttpServletRequest)req, (HttpServletResponse)rsp, null);
    }

    public void doFinishLogin(StaplerRequest req, StaplerResponse rsp) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        LOG.debug("Finishing CAS login with authentication={}", (Object)authentication);
        req.getSession();
        if (authentication instanceof CasAuthenticationToken) {
            SecurityListener.fireAuthenticated2((UserDetails)((CasAuthenticationToken)authentication).getUserDetails());
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "CAS (Central Authentication Service)";
        }

        @RequirePOST
        public FormValidation doCheckCasServerUrl(@QueryParameter String value) throws IOException, ServletException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            value = Util.fixEmptyAndTrim((String)value);
            if (value == null) {
                return FormValidation.error((String)Messages.CasSecurityRealm_casServerUrl_missingUrl());
            }
            try {
                URL url = new URL(StringUtils.stripEnd((String)value, (String)"/") + "/login");
                String response = CommonUtils.getResponseFromServer((URL)url, (String)"UTF-8");
                if (!response.contains("username")) {
                    return FormValidation.warning((String)Messages.CasSecurityRealm_casServerUrl_invalidResponse());
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)(Messages.CasSecurityRealm_casServerUrl_malformedUrl() + ": " + e.getMessage()));
            }
            catch (RuntimeException e) {
                return FormValidation.error((String)(Messages.CasSecurityRealm_casServerUrl_cannotGetResponse() + ": " + (e.getCause() == null ? e : e.getCause())));
            }
            return FormValidation.ok();
        }
    }
}

