/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.security.cas.ServiceProperties;

public abstract class CasProtocol
extends AbstractDescribableImpl<CasProtocol>
implements ExtensionPoint {
    public final String authoritiesAttribute;
    public final String fullNameAttribute;
    public final String emailAttribute;
    public final String customValidationParams;
    protected transient String artifactParameter = null;
    protected transient List<String> authoritiesAttributes = null;
    protected transient Map<String, String> customValidationParamsMap = null;

    protected CasProtocol() {
        this(null, null, null);
    }

    protected CasProtocol(String authoritiesAttribute) {
        this(authoritiesAttribute, null, null);
    }

    protected CasProtocol(String authoritiesAttribute, String fullNameAttribute, String emailAttribute) {
        this(authoritiesAttribute, fullNameAttribute, emailAttribute, null);
    }

    protected CasProtocol(String authoritiesAttribute, String fullNameAttribute, String emailAttribute, String customValidationParams) {
        this.authoritiesAttribute = Util.fixEmptyAndTrim((String)authoritiesAttribute);
        this.fullNameAttribute = Util.fixEmptyAndTrim((String)fullNameAttribute);
        this.emailAttribute = Util.fixEmptyAndTrim((String)emailAttribute);
        this.customValidationParams = Util.fixEmptyAndTrim((String)customValidationParams);
    }

    public String getArtifactParameter() {
        if (this.artifactParameter == null) {
            this.artifactParameter = this.createServiceProperties().getArtifactParameter();
        }
        return this.artifactParameter;
    }

    public String getAuthoritiesAttribute() {
        return this.authoritiesAttribute;
    }

    public List<String> getAuthoritiesAttributes() {
        if (this.authoritiesAttributes == null) {
            this.authoritiesAttributes = Arrays.asList(StringUtils.split((String)this.getAuthoritiesAttribute(), (String)","));
        }
        return this.authoritiesAttributes;
    }

    public String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public String getCustomValidationParams() {
        return this.customValidationParams;
    }

    public Map<String, String> getCustomValidationParamsMap() {
        if (this.customValidationParamsMap == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (this.customValidationParams != null) {
                String[] parts;
                for (String part : parts = StringUtils.split((String)this.customValidationParams, (String)"&")) {
                    String[] keyValue = StringUtils.split((String)part, (String)"=");
                    if (keyValue.length != 2) continue;
                    try {
                        map.put(keyValue[0], URLDecoder.decode(keyValue[1], "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            this.customValidationParamsMap = map;
        }
        return this.customValidationParamsMap;
    }

    public ServiceProperties createServiceProperties() {
        return new ServiceProperties();
    }

    public abstract TicketValidator createTicketValidator(String var1);

    public static DescriptorExtensionList<CasProtocol, Descriptor<CasProtocol>> all() {
        return Jenkins.get().getDescriptorList(CasProtocol.class);
    }
}

