/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.session.SingleSignOutHandler;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class CasSingleSignOutFilter
extends GenericFilterBean {
    private boolean enabled = true;
    private String filterProcessesUrl = "/j_spring_cas_security_check";
    private SingleSignOutHandler singleSignOutHandler;

    public void afterPropertiesSet() throws ServletException {
        Assert.hasLength((String)this.filterProcessesUrl, (String)"filterProcessesUrl must be specified");
        Assert.notNull((Object)this.singleSignOutHandler, (String)"singleSignOutHandler cannot be null");
        this.singleSignOutHandler.init();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (!this.enabled || !this.requiresProcessing(request, response)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.singleSignOutHandler.process(request, response)) {
            chain.doFilter(req, res);
        }
    }

    protected boolean requiresProcessing(HttpServletRequest request, HttpServletResponse response) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        if ("".equals(request.getContextPath())) {
            return uri.endsWith(this.filterProcessesUrl);
        }
        return uri.endsWith(request.getContextPath() + this.filterProcessesUrl);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
    }

    public SingleSignOutHandler getSingleSignOutHandler() {
        return this.singleSignOutHandler;
    }

    public void setSingleSignOutHandler(SingleSignOutHandler singleSignOutHandler) {
        this.singleSignOutHandler = singleSignOutHandler;
    }
}

