/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.web.authentication.ServiceAuthenticationDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

public final class CasRestAuthenticator
implements InitializingBean,
AuthenticationManager {
    private static final String CAS_V1_TICKETS = "v1/tickets";
    private static final String ENCODING = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(CasRestAuthenticator.class);
    private String casServerUrl;
    private AuthenticationManager authenticationManager;
    private AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.casServerUrl, (String)"casServerUrl cannot be null");
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager cannot be null");
        Assert.notNull(this.authenticationDetailsSource, (String)"authenticationDetailsSource cannot be null");
    }

    public String getCasServerUrl() {
        return this.casServerUrl;
    }

    public void setCasServerUrl(String casServerUrl) {
        this.casServerUrl = casServerUrl;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> getAuthenticationDetailsSource() {
        return this.authenticationDetailsSource;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            return this.authenticate((UsernamePasswordAuthenticationToken)authentication);
        }
        throw new BadCredentialsException("Unexpected authentication type: " + authentication);
    }

    public Authentication authenticate(UsernamePasswordAuthenticationToken token) {
        return this.authenticate(token.getPrincipal().toString(), token.getCredentials().toString());
    }

    public Authentication authenticate(String username, String password) throws AuthenticationException {
        String grantingTicket = this.fetchGrantingTicket(username, password);
        if (grantingTicket != null) {
            try {
                String serviceTicket = this.fetchServiceTicket(grantingTicket);
                if (serviceTicket != null) {
                    Authentication authentication = this.validateServiceTicket(serviceTicket);
                    return authentication;
                }
                throw new AuthenticationServiceException("Could not fetch service ticket from CAS");
            }
            finally {
                this.destroyGrantingTicket(grantingTicket);
            }
        }
        throw new AuthenticationServiceException("Could not fetch granting ticket from CAS");
    }

    private String createGrantingTicketUrl() {
        return this.casServerUrl + CAS_V1_TICKETS;
    }

    private String createGrantingTicketPostContent(String username, String password) throws UnsupportedEncodingException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("username=").append(this.encode(username));
        buffer.append("&password=").append(this.encode(password));
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchGrantingTicket(String username, String password) {
        String grantingTicket = null;
        HttpURLConnection connection = null;
        try {
            connection = this.openConnection(this.createGrantingTicketUrl());
            String post = this.createGrantingTicketPostContent(username, password);
            this.writeContent(connection, post);
            grantingTicket = this.extractGrantingTicket(connection);
        }
        catch (IOException ex) {
            LOG.error("Failed to obtain a ticket granting ticket from CAS", (Throwable)ex);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return grantingTicket;
    }

    private String extractGrantingTicket(HttpURLConnection connection) throws IOException {
        String grantingTicket = null;
        int rc = connection.getResponseCode();
        if (rc == 201) {
            String location = connection.getHeaderField("location");
            if (location != null && location.length() > 0) {
                int index = location.lastIndexOf(47);
                if (index > 0) {
                    grantingTicket = location.substring(location.lastIndexOf(47) + 1);
                } else {
                    LOG.warn("CAS returned invalid location header");
                }
            } else {
                LOG.warn("CAS did not return a location header");
            }
        } else {
            LOG.warn("CAS returned status code {}, during granting ticket extraction", (Object)rc);
        }
        return grantingTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyGrantingTicket(String grantingTicket) {
        HttpURLConnection connection = null;
        try {
            connection = this.openConnection(this.createServiceTicketUrl(grantingTicket), "DELETE");
            int rc = connection.getResponseCode();
            if (rc != 200) {
                LOG.warn("CAS returned status code {}, during granting ticket destruction", (Object)rc);
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to destroy granting ticket from CAS", (Throwable)ex);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String createServiceTicketUrl(String grantingTicket) {
        return this.casServerUrl + CAS_V1_TICKETS + '/' + grantingTicket;
    }

    private String createServiceTicketPostContent() throws UnsupportedEncodingException {
        return "service=".concat(this.encode(((ServiceAuthenticationDetails)this.authenticationDetailsSource.buildDetails(null)).getServiceUrl()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchServiceTicket(String grantingTicket) {
        String serviceTicket = null;
        HttpURLConnection connection = null;
        try {
            connection = this.openConnection(this.createServiceTicketUrl(grantingTicket));
            String post = this.createServiceTicketPostContent();
            this.writeContent(connection, post);
            serviceTicket = this.extractServiceTicket(connection);
        }
        catch (IOException ex) {
            LOG.error("Failed to obtain a service ticket from CAS", (Throwable)ex);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return serviceTicket;
    }

    private String extractServiceTicket(HttpURLConnection connection) throws IOException {
        String serviceTicket = null;
        int rc = connection.getResponseCode();
        if (rc == 200) {
            serviceTicket = this.readContent(connection);
            if (serviceTicket != null) {
                serviceTicket = serviceTicket.trim();
            }
        } else {
            LOG.warn("CAS returned status code {}, during service ticket extraction", (Object)rc);
        }
        return serviceTicket;
    }

    private Authentication validateServiceTicket(String serviceTicket) {
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)"_cas_stateful_", (Object)serviceTicket);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails(null));
        return this.authenticationManager.authenticate((Authentication)authRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContent(HttpURLConnection connection) throws IOException {
        String content = null;
        try (InputStream inputStream = null;){
            int length;
            inputStream = connection.getInputStream();
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            content = result.toString(ENCODING);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContent(HttpURLConnection connection, String content) throws IOException {
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), ENCODING));
            writer.write(content);
            writer.flush();
        }
    }

    private String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, ENCODING);
    }

    private HttpURLConnection openConnection(String url) throws IOException {
        return this.openConnection(url, "POST");
    }

    private HttpURLConnection openConnection(String url, String method) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod(method);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }
}

