/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.jenkinsci.plugins.cas.spring.security.CasAuthentication;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.AuthenticationException;

public class AcegiAuthenticationManager
implements AuthenticationManager {
    private final org.springframework.security.authentication.AuthenticationManager authenticationManager;

    public AcegiAuthenticationManager(org.springframework.security.authentication.AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public Authentication authenticate(Authentication authentication) throws org.acegisecurity.AuthenticationException {
        try {
            return this.mapAuthResponse(this.authenticationManager.authenticate(this.mapAuthRequest(authentication)));
        }
        catch (AuthenticationException e) {
            throw this.mapAuthException(e);
        }
    }

    protected org.springframework.security.core.Authentication mapAuthRequest(Authentication authentication) {
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)authentication;
            return new org.springframework.security.authentication.UsernamePasswordAuthenticationToken(token.getPrincipal(), token.getCredentials());
        }
        throw new UnsupportedOperationException("Unexpected authentication type: " + authentication);
    }

    protected Authentication mapAuthResponse(org.springframework.security.core.Authentication authentication) {
        if (authentication instanceof CasAuthenticationToken) {
            return CasAuthentication.newInstance((CasAuthenticationToken)authentication);
        }
        throw new UnsupportedOperationException("Unsupported authentication type: " + authentication);
    }

    protected org.acegisecurity.AuthenticationException mapAuthException(AuthenticationException e) {
        if (e instanceof org.springframework.security.authentication.DisabledException) {
            return new DisabledException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof LockedException) {
            return new org.acegisecurity.LockedException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof BadCredentialsException) {
            return new org.acegisecurity.BadCredentialsException(e.getMessage(), (Throwable)e);
        }
        return new AuthenticationServiceException(e.getMessage(), (Throwable)e);
    }
}

