/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.validator;

import com.agiletestware.bumblebee.validator.StringNotEmptyValidator;
import com.agiletestware.bumblebee.validator.Validator;
import hudson.util.FormValidation;

public class StringStartsWithValidator
implements Validator<String, Void> {
    private final StringNotEmptyValidator<Void> notEmptyValidator;
    private final String startsWith;
    private final String errorMessage;

    public StringStartsWithValidator(String startsWith, String errorMessageOnEmpty, String errorMessage) {
        if (startsWith == null) {
            throw new IllegalArgumentException("startWith cannot be null");
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException("errorMessage cannot be null");
        }
        this.notEmptyValidator = new StringNotEmptyValidator(errorMessageOnEmpty);
        this.startsWith = startsWith;
        this.errorMessage = errorMessage;
    }

    @Override
    public FormValidation validate(String value, Void param) {
        FormValidation validation = this.notEmptyValidator.validate(value, (Void)null);
        if (FormValidation.Kind.ERROR == validation.kind) {
            return validation;
        }
        return value.startsWith(this.startsWith) ? FormValidation.ok() : FormValidation.error((String)this.errorMessage);
    }
}

