/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.validator;

import com.agiletestware.bumblebee.client.utils.UrlAvailableValidator;
import com.agiletestware.bumblebee.validator.StringNotEmptyValidator;
import com.agiletestware.bumblebee.validator.Validator;
import hudson.util.FormValidation;
import java.text.MessageFormat;

public class CustomUrlAvailableValidator
implements Validator<String, Integer> {
    private final StringNotEmptyValidator<Void> notEmptyValidator;
    private final String errorMessage;
    private final UrlAvailableValidator urlAvailableValidator;

    public CustomUrlAvailableValidator(String emptyErrorMessage, String errorMessage, UrlAvailableValidator urlAvailableValidator) {
        this.notEmptyValidator = new StringNotEmptyValidator(emptyErrorMessage);
        this.errorMessage = errorMessage;
        this.urlAvailableValidator = urlAvailableValidator;
    }

    @Override
    public FormValidation validate(String value, Integer timeout) {
        FormValidation validation = this.notEmptyValidator.validate(value, (Void)null);
        if (FormValidation.Kind.OK != validation.kind) {
            return validation;
        }
        return this.urlAvailableValidator.isUrlReachable(value, timeout) ? FormValidation.ok() : FormValidation.error((String)MessageFormat.format(this.errorMessage, value));
    }
}

