/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.uft;

import com.agiletestware.bumblebee.ReportFolderProvider;
import com.agiletestware.bumblebee.client.runner.ExecutionEnvironment;
import com.agiletestware.bumblebee.client.runner.FileProvider;
import com.agiletestware.bumblebee.client.runner.Runner;
import com.agiletestware.bumblebee.client.runner.TestPathFileProvider;
import com.agiletestware.bumblebee.client.uftrunner.UftCommandLineBuilder;
import com.agiletestware.bumblebee.client.uftrunner.UftRunnerParameters;
import com.agiletestware.bumblebee.client.utils.BuildLogger;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class UftRunner
implements Runner<UftRunnerParameters, Integer>,
Serializable {
    private static final long serialVersionUID = -4096227064300451050L;
    private final FilePath workspace;
    private final TaskListener listener;

    public UftRunner(FilePath workspace, TaskListener listener) {
        this.workspace = workspace;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer run(UftRunnerParameters parameters, ExecutionEnvironment context, BuildLogger buildLogger) throws Exception {
        File report = new File(context.getWorkingDir(), UUID.randomUUID().toString());
        try {
            parameters.setReportFileName(report.getAbsolutePath());
            UftCommandLineBuilder uftBuilder = new UftCommandLineBuilder(parameters, (FileProvider)new ReportFolderProvider(new File(this.workspace.getRemote())), (FileProvider)new TestPathFileProvider(new File(this.workspace.getRemote())));
            List cmdList = uftBuilder.getCommandLineArguments(context, true);
            Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(this.listener);
            Proc proc = launcher.launch().cmds(cmdList).pwd(context.getBumblebeeDir()).readStdout().start();
            PrintStream stream = this.listener.getLogger();
            Serializable serializable = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getStdout()), 4096);){
                String line;
                while ((line = reader.readLine()) != null) {
                    stream.println(line);
                }
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            int code = proc.join();
            stream.println("Return code: " + code);
            serializable = Integer.valueOf(code);
            return serializable;
        }
        finally {
            FileUtils.deleteQuietly((File)report);
        }
    }
}

