/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.testset;

import com.agiletestware.bumblebee.JenkinsBuildLogger;
import com.agiletestware.bumblebee.ReportFolderProvider;
import com.agiletestware.bumblebee.client.api.BumblebeeParameters;
import com.agiletestware.bumblebee.client.runner.ExecutionEnvironment;
import com.agiletestware.bumblebee.client.runner.ExternalProcessRunner;
import com.agiletestware.bumblebee.client.runner.Runner;
import com.agiletestware.bumblebee.client.testrunner.TestSetCommandLineBuilder;
import com.agiletestware.bumblebee.client.testrunner.TestSetRunner;
import com.agiletestware.bumblebee.client.testrunner.TestSetRunnerParameters;
import com.agiletestware.bumblebee.client.utils.BuildLogger;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.List;
import org.jenkinsci.remoting.RoleChecker;

public class RunTestSetTask
implements Callable<Integer, Exception> {
    private static final long serialVersionUID = 6667786334878876264L;
    private final TaskListener listener;
    private final FilePath jenkinsDirPath;
    private final FilePath workspace;
    private final TestSetRunnerParameters parameters;

    public RunTestSetTask(TaskListener listener, FilePath jenkinsDirPath, FilePath workspace, TestSetRunnerParameters parameters) {
        this.listener = listener;
        this.jenkinsDirPath = jenkinsDirPath;
        this.workspace = workspace;
        this.parameters = parameters;
    }

    public Integer call() throws Exception {
        File jenkinsDir = new File(this.jenkinsDirPath.getRemote());
        TestSetRunner runner = new TestSetRunner(new ReportFolderProvider(new File(this.workspace.getRemote()))){

            protected Integer runTestSets(TestSetCommandLineBuilder cmdBuilder, File projectXml, File outputDirectory, ExecutionEnvironment environment, BuildLogger logger) throws Exception {
                List cmdList = cmdBuilder.getCommandLineArguments(RunTestSetTask.this.parameters, true);
                Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(RunTestSetTask.this.listener);
                Proc proc = launcher.launch().cmds(cmdList).pwd(environment.getBumblebeeDir()).readStdout().start();
                PrintStream stream = RunTestSetTask.this.listener.getLogger();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getStdout()), 4096);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        stream.println(line);
                    }
                }
                int code = proc.join();
                stream.println("Return code: " + code);
                return code;
            }
        };
        return (Integer)new ExternalProcessRunner(jenkinsDir).run((Runner)runner, (BumblebeeParameters)this.parameters, (BuildLogger)new JenkinsBuildLogger(this.listener));
    }

    public void checkRoles(RoleChecker arg0) throws SecurityException {
    }
}

