/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.testset;

import com.agiletestware.bumblebee.BumblebeeGlobalConfig;
import com.agiletestware.bumblebee.client.api.AddTestToSetParameters;
import com.agiletestware.bumblebee.testset.AddTestToSetCallable;
import com.agiletestware.bumblebee.testset.AddTestToSetEnvSpecificParameters;
import com.agiletestware.bumblebee.testset.AddTestToSetParametersFactory;
import com.agiletestware.bumblebee.util.BumblebeeUtils;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import jenkins.model.GlobalConfiguration;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AddTestToSetStep
extends Builder
implements SimpleBuildStep {
    private final String domain;
    private final String project;
    private final String testPlanPath;
    private final String testSetPath;

    @DataBoundConstructor
    public AddTestToSetStep(String domain, String project, String testPlanPath, String testSetPath) {
        this.domain = domain;
        this.project = project;
        this.testPlanPath = testPlanPath;
        this.testSetPath = testSetPath;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        logger.println("Start adding tests from " + this.testPlanPath + " to " + this.testSetPath);
        BumblebeeGlobalConfig globalConfig = (BumblebeeGlobalConfig)((Object)GlobalConfiguration.all().get(BumblebeeGlobalConfig.class));
        AddTestToSetEnvSpecificParameters params = new AddTestToSetEnvSpecificParameters(AddTestToSetParametersFactory.THE_INSTANCE.create(this, globalConfig), run.getEnvironment(listener));
        this.logParameters(params, logger);
        try {
            launcher.getChannel().call((Callable)new AddTestToSetCallable(params, globalConfig.getTimeOut()));
            logger.println("Tests were added");
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw new AbortException("Could not add tests " + this.testPlanPath + " to " + this.testSetPath + ". Reason: " + e.getMessage());
        }
    }

    private void logParameters(AddTestToSetParameters parameters, PrintStream logger) {
        logger.println("Parameters:");
        logger.println("Bumblebee URL: " + parameters.getBumbleBeeUrl());
        logger.println("HP ALM URL: " + parameters.getAlmUrl());
        logger.println("HP ALM User: " + parameters.getAlmUserName());
        logger.println("HP ALM Domain: " + parameters.getDomain());
        logger.println("HP ALM Project: " + parameters.getProject());
        logger.println("Test Plan Path: " + parameters.getTestPlanPath());
        logger.println("Test Set Path: " + parameters.getTestSetPath());
    }

    public String getDomain() {
        return this.domain;
    }

    public String getProject() {
        return this.project;
    }

    public String getTestPlanPath() {
        return this.testPlanPath;
    }

    public String getTestSetPath() {
        return this.testSetPath;
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            super(AddTestToSetStep.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Bumblebee: Add Test to Test Set";
        }

        public FormValidation doCheckDomain(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String domain) {
            project.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateRequiredField(domain);
        }

        public FormValidation doCheckProject(@AncestorInPath AbstractProject<?, ?> abstrProject, @QueryParameter String project) {
            abstrProject.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateRequiredField(project);
        }

        public FormValidation doCheckTestPlanPath(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String testPlanPath) {
            project.checkPermission(Job.CONFIGURE);
            if (StringUtils.isEmpty((String)testPlanPath)) {
                return FormValidation.error((String)"Required");
            }
            if (!testPlanPath.startsWith("Subject\\")) {
                return FormValidation.error((String)"Test set must start with Subject\\");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTestSetPath(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String testSetPath) {
            project.checkPermission(Job.CONFIGURE);
            if (StringUtils.isEmpty((String)testSetPath)) {
                return FormValidation.error((String)"Required");
            }
            if (!testSetPath.startsWith("Root\\")) {
                return FormValidation.error((String)"Test set must start with Root\\");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOutputDirPath(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String checkOutputDirPath) {
            project.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateRequiredField(checkOutputDirPath);
        }
    }
}

