/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.results;

import com.agiletestware.bumblebee.BumblebeeGlobalConfig;
import com.agiletestware.bumblebee.client.api.BumblebeeApi;
import com.agiletestware.bumblebee.client.api.BumblebeeApiProvider;
import com.agiletestware.bumblebee.client.api.DefaultBumblebeeApiProvider;
import com.agiletestware.bumblebee.results.DefaultGetTestResultsParametersFactory;
import com.agiletestware.bumblebee.results.GetTestResultsConfiguration;
import com.agiletestware.bumblebee.results.GetTestResultsEnvSpecificParams;
import com.agiletestware.bumblebee.results.GetTestResultsParameters;
import com.agiletestware.bumblebee.results.GetTestResultsParametersFactory;
import com.agiletestware.bumblebee.util.BumblebeeUtils;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GetTestResults
extends Recorder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(GetTestResults.class.getName());
    private static final String PLUGIN_DISPLAY_NAME = "Bumblebee: Import HP ALM Test Results";
    private transient BumblebeeApiProvider bumblebeeApiProvider = new DefaultBumblebeeApiProvider();
    private final transient GetTestResultsParametersFactory parametersFactory = DefaultGetTestResultsParametersFactory.THE_INSTANCE;
    private final String domain;
    private final String project;
    private String user;
    private String password;
    private final String resultsDir;
    private final List<GetTestResultsConfiguration> configurations;

    @DataBoundConstructor
    public GetTestResults(String domain, String project, String user, String password, String resultsDir, List<GetTestResultsConfiguration> configurations) {
        this.domain = Util.fixEmptyAndTrim((String)domain);
        this.project = Util.fixEmptyAndTrim((String)project);
        this.user = Util.fixEmptyAndTrim((String)user);
        String plainPassword = Util.fixEmptyAndTrim((String)password);
        this.password = plainPassword != null ? Secret.fromString((String)plainPassword).getEncryptedValue() : null;
        this.resultsDir = Util.fixEmptyAndTrim((String)resultsDir);
        this.configurations = configurations;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        boolean success = true;
        PrintStream logger = listener.getLogger();
        BumblebeeGlobalConfig globalConfig = (BumblebeeGlobalConfig)((Object)GlobalConfiguration.all().get(BumblebeeGlobalConfig.class));
        this.assertGlobalConfig(globalConfig);
        String bumblebeeUrl = globalConfig.getBumblebeeUrl();
        try (BumblebeeApi api = this.bumblebeeApiProvider.provide(bumblebeeUrl, (int)TimeUnit.MINUTES.toSeconds(globalConfig.getTimeOut()));){
            String encryptedPassword = StringUtils.isNotEmpty((String)this.password) ? api.getEncryptedPassword(Secret.decrypt((String)this.password).getPlainText()) : null;
            for (GetTestResultsConfiguration configuration : this.configurations) {
                try {
                    logger.println("Fetching test results from HP ALM");
                    GetTestResultsEnvSpecificParams params = new GetTestResultsEnvSpecificParams(this.parametersFactory.create(globalConfig, this, configuration), run.getEnvironment(listener));
                    if (encryptedPassword != null) {
                        params.setEncryptedPassword(encryptedPassword);
                    }
                    this.logParameters(bumblebeeUrl, params, this.resultsDir, logger);
                    FilePath reportFile = workspace.child(this.resultsDir).child(this.createFileName(params.getTestSetPath()));
                    InputStream stream = api.getJunitTestResults((GetTestResultsParameters)params);
                    Throwable throwable = null;
                    try {
                        logger.println("Writing results into: " + reportFile.getRemote());
                        OutputStream out = reportFile.write();
                        Throwable throwable2 = null;
                        try {
                            IOUtils.copy((InputStream)stream, (OutputStream)out);
                            out.flush();
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (out == null) continue;
                            if (throwable2 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            out.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (Exception ex) {
                    logger.println(ex.getMessage());
                    LOGGER.log(Level.SEVERE, null, ex);
                    success = false;
                }
            }
        }
        catch (Exception ex) {
            logger.println(ex.getMessage());
            LOGGER.log(Level.SEVERE, null, ex);
            throw new AbortException(ex.getMessage());
        }
        if (!success) {
            throw new AbortException("One or more configurations have fail --> mark build as failure. Check the log for details");
        }
    }

    private void assertGlobalConfig(BumblebeeGlobalConfig globalConfig) throws AbortException {
        if (globalConfig == null) {
            throw new AbortException("Bumblebee Global configuration is not set propertly. Please configure Bumblebee Global settings");
        }
        String bumblebeeUrl = globalConfig.getBumblebeeUrl();
        if (StringUtils.isEmpty((String)bumblebeeUrl)) {
            throw new AbortException("Bumblebee URL is not set. Please set a valid URL on Bumblebee Global configuration page");
        }
    }

    public List<GetTestResultsConfiguration> getConfigurations() {
        return this.configurations;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getProject() {
        return this.project;
    }

    public String getUser() {
        return this.user;
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = password;
    }

    void setBumblebeeApiProvider(BumblebeeApiProvider bumblebeeApiProvider) {
        this.bumblebeeApiProvider = bumblebeeApiProvider;
    }

    private String createFileName(String testSetPath) {
        return testSetPath.replaceAll("[\\\\/:*?\"<>|]", "_") + "_" + System.currentTimeMillis() + ".xml";
    }

    private void logParameters(String bumblebeeUrl, GetTestResultsParameters params, String resultsDir, PrintStream logger) {
        logger.println("Parameters:");
        logger.println("Bumblebee URL: " + bumblebeeUrl);
        logger.println("HP ALM URL: " + params.getAlmUrl());
        logger.println("HP ALM User: " + params.getAlmUserName());
        logger.println("HP ALM Domain: " + params.getDomain());
        logger.println("HP ALM Project: " + params.getProject());
        logger.println("Test Lab Path: " + params.getTestSetPath());
        logger.println("Results directory: " + resultsDir);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return GetTestResults.PLUGIN_DISPLAY_NAME;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckDomain(@QueryParameter String domain) throws IOException, ServletException {
            return BumblebeeUtils.validateRequiredField(domain);
        }

        public FormValidation doCheckProject(@QueryParameter String project) throws IOException, ServletException {
            return BumblebeeUtils.validateRequiredField(project);
        }

        public FormValidation doCheckTestSetPath(@QueryParameter String testSetPath) throws IOException, ServletException {
            return BumblebeeUtils.validateTestLab(testSetPath, "Test Set Path");
        }

        public FormValidation doCheckResultsDir(@QueryParameter String resultsDir) throws IOException, ServletException {
            return BumblebeeUtils.validateRequiredField(resultsDir);
        }
    }
}

