/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.pc;

import com.agiletestware.bumblebee.BumblebeeGlobalConfig;
import com.agiletestware.bumblebee.BumblebeePublisher;
import com.agiletestware.bumblebee.JenkinsBuildLogger;
import com.agiletestware.bumblebee.client.ParametersLogger;
import com.agiletestware.bumblebee.client.api.BumblebeeApiProvider;
import com.agiletestware.bumblebee.client.api.DefaultBumblebeeApiProvider;
import com.agiletestware.bumblebee.client.pc.RunPcTestContext;
import com.agiletestware.bumblebee.client.utils.BuildLogger;
import com.agiletestware.bumblebee.encryption.CustomSecret;
import com.agiletestware.bumblebee.encryption.DefaultCustomSecret;
import com.agiletestware.bumblebee.pc.PostRunAction;
import com.agiletestware.bumblebee.pc.RunPcTestContextImpl;
import com.agiletestware.bumblebee.pc.RunPerformanceTestCallable;
import com.agiletestware.bumblebee.validator.StringNotEmptyValidator;
import com.agiletestware.bumblebee.validator.StringStartsWithValidator;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class RunPcTestBuildStep
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(BumblebeePublisher.class.getName());
    private CustomSecret customSecret = DefaultCustomSecret.THE_INSTANCE;
    private String project;
    private String domain;
    private String almUser;
    private String almPassword;
    private String outputDir;
    private String testPlanPath;
    private String testLabPath;
    private String postRunActionString;
    private int timeslotDuration;
    private boolean vudsMode;
    private int timeout;
    private int retryCount;
    private int retryInterval;
    private double retryIntervalMultiplier;
    private boolean retryCollateAndAnalysisFlag;
    private int retryCollateAndAnalysisAttempts;
    private int retryCollateAndAnalysisInterval;
    private int pollingInterval;
    private boolean failIfTaskFails;

    @DataBoundConstructor
    public RunPcTestBuildStep() {
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    @DataBoundSetter
    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public String getTestPlanPath() {
        return this.testPlanPath;
    }

    @DataBoundSetter
    public void setTestPlanPath(String testPlanPath) {
        this.testPlanPath = testPlanPath;
    }

    public String getTestLabPath() {
        return this.testLabPath;
    }

    @DataBoundSetter
    public void setTestLabPath(String testLabPath) {
        this.testLabPath = testLabPath;
    }

    public String getPostRunActionString() {
        return this.postRunActionString;
    }

    public PostRunAction getPostRunAction() {
        return StringUtils.isNotEmpty((String)this.postRunActionString) ? PostRunAction.fromLabel((String)this.postRunActionString) : null;
    }

    @DataBoundSetter
    public void setPostRunActionString(String postRunActionString) {
        this.postRunActionString = postRunActionString;
    }

    public int getTimeslotDuration() {
        return this.timeslotDuration;
    }

    @DataBoundSetter
    public void setTimeslotDuration(int timeslotDuration) {
        this.timeslotDuration = timeslotDuration;
    }

    public boolean isVudsMode() {
        return this.vudsMode;
    }

    @DataBoundSetter
    public void setVudsMode(boolean vudsMode) {
        this.vudsMode = vudsMode;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    @DataBoundSetter
    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    @DataBoundSetter
    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    @DataBoundSetter
    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    public boolean isRetryCollateAndAnalysisFlag() {
        return this.retryCollateAndAnalysisFlag;
    }

    @DataBoundSetter
    public void setRetryCollateAndAnalysisFlag(boolean retryCollateAndAnalysisFlag) {
        this.retryCollateAndAnalysisFlag = retryCollateAndAnalysisFlag;
    }

    public int getRetryCollateAndAnalysisInterval() {
        return this.retryCollateAndAnalysisInterval;
    }

    @DataBoundSetter
    public void setRetryCollateAndAnalysisInterval(int retryCollateAndAnalysisInterval) {
        this.retryCollateAndAnalysisInterval = retryCollateAndAnalysisInterval;
    }

    public int getRetryCollateAndAnalysisAttempts() {
        return this.retryCollateAndAnalysisAttempts;
    }

    @DataBoundSetter
    public void setRetryCollateAndAnalysisAttempts(int retryCollateAndAnalysisAttempts) {
        this.retryCollateAndAnalysisAttempts = retryCollateAndAnalysisAttempts;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    @DataBoundSetter
    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public boolean isFailIfTaskFails() {
        return this.failIfTaskFails;
    }

    @DataBoundSetter
    public void setFailIfTaskFails(boolean failIfTaskFails) {
        this.failIfTaskFails = failIfTaskFails;
    }

    public String getProject() {
        return this.project;
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    public String getDomain() {
        return this.domain;
    }

    @DataBoundSetter
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getAlmUser() {
        return this.almUser;
    }

    @DataBoundSetter
    public void setAlmUser(String almUser) {
        this.almUser = almUser;
    }

    public String getAlmPassword() {
        return this.almPassword;
    }

    @DataBoundSetter
    public void setAlmPassword(String almPassword) {
        String plainTextPassword = Util.fixEmpty((String)almPassword);
        this.almPassword = plainTextPassword != null ? this.customSecret.getEncryptedValue(plainTextPassword) : null;
    }

    void setCustomSecret(CustomSecret customSecret) {
        this.customSecret = customSecret;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        logger.println("Start Performance Center test");
        try {
            RunPcTestContextImpl context = new RunPcTestContextImpl(this, (BumblebeeGlobalConfig)((Object)GlobalConfiguration.all().get(BumblebeeGlobalConfig.class)), workspace, this.customSecret, (BumblebeeApiProvider)new DefaultBumblebeeApiProvider());
            ParametersLogger.THE_INSTANCE.logParameters((RunPcTestContext)context, (BuildLogger)new JenkinsBuildLogger(listener), this.isFailIfTaskFails());
            RunPerformanceTestCallable callable = new RunPerformanceTestCallable(context, listener, run.getStartTimeInMillis());
            launcher.getChannel().call((Callable)callable);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            if (this.isFailIfTaskFails()) {
                e.printStackTrace(logger);
                throw new AbortException(e.getMessage());
            }
            logger.println(e.getMessage());
            e.printStackTrace(logger);
            logger.println("Fail If Task Fail flag is set to false -> continue build regardless of the error");
        }
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        private static final StringNotEmptyValidator<Void> NOT_EMPTY_VALIDATOR = new StringNotEmptyValidator("Required");
        private static StringStartsWithValidator TEST_PATH_VALIDATOR = new StringStartsWithValidator("Subject\\", "Test Path is required", "Test Path must start with Subject\\");
        private static final StringStartsWithValidator TEST_SET_VALIDATOR = new StringStartsWithValidator("Root\\", "Test Set is required", "Test Set must start with Root\\");

        public Descriptor() {
            super(RunPcTestBuildStep.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Bumblebee HP PC Test Runner";
        }

        public List<String> getAllRunActions() {
            return PostRunAction.getLabels();
        }

        public FormValidation doCheckDomain(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String domain) {
            project.checkPermission(Job.CONFIGURE);
            return NOT_EMPTY_VALIDATOR.validate(domain, (Void)null);
        }

        public FormValidation doCheckProject(@AncestorInPath AbstractProject<?, ?> abstrProj, @QueryParameter String project) {
            abstrProj.checkPermission(Job.CONFIGURE);
            return NOT_EMPTY_VALIDATOR.validate(project, (Void)null);
        }

        public FormValidation doCheckOutputDir(@AncestorInPath AbstractProject<?, ?> abstrProj, @QueryParameter String outputDir) {
            abstrProj.checkPermission(Job.CONFIGURE);
            return NOT_EMPTY_VALIDATOR.validate(outputDir, (Void)null);
        }

        public FormValidation doCheckTestPlanPath(@AncestorInPath AbstractProject<?, ?> abstrProj, @QueryParameter String testPlanPath) {
            abstrProj.checkPermission(Job.CONFIGURE);
            return TEST_PATH_VALIDATOR.validate(testPlanPath, null);
        }

        public FormValidation doCheckTestLabPath(@AncestorInPath AbstractProject<?, ?> abstrProj, @QueryParameter String testLabPath) {
            abstrProj.checkPermission(Job.CONFIGURE);
            return TEST_SET_VALIDATOR.validate(testLabPath, null);
        }
    }
}

