/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildgraphview;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.TriggerBuilder;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.tasks.BuildStep;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.DependencyDeclarer;
import org.jenkinsci.plugins.buildgraphview.DownStreamRunDeclarer;

@Extension(optional=true)
public class PromotedBuildTriggerDownStreamRunDeclarer
extends DownStreamRunDeclarer {
    public static final Class clazz = PromotedBuildAction.class;

    @Override
    public List<Run> getDownStream(Run r) {
        ArrayList<Run> runs = new ArrayList<Run>();
        ArrayList result = new ArrayList();
        DependencyGraph graph = new DependencyGraph();
        AbstractProject project = ((AbstractBuild)r).getProject();
        JobPropertyImpl property = (JobPropertyImpl)((AbstractBuild)r).getProject().getProperty(JobPropertyImpl.class);
        if (property != null) {
            List promotionProcesses = property.getActiveItems();
            for (PromotionProcess promotionProcess : promotionProcesses) {
                List buildSteps = promotionProcess.getBuildSteps();
                for (BuildStep buildStep : buildSteps) {
                    if (!(buildStep instanceof DependencyDeclarer)) continue;
                    ((DependencyDeclarer)buildStep).buildDependencyGraph((AbstractProject)promotionProcess, graph);
                }
                result.addAll(graph.getDownstream((AbstractProject)promotionProcess));
                for (BuildStep buildStep : buildSteps) {
                    List configs;
                    if (buildStep instanceof BuildTrigger) {
                        BuildTrigger buildTrigger = (BuildTrigger)buildStep;
                        configs = buildTrigger.getConfigs();
                        for (BuildTriggerConfig config : configs) {
                            result.addAll(config.getProjectList(project.getParent(), null));
                        }
                    }
                    if (!(buildStep instanceof TriggerBuilder)) continue;
                    TriggerBuilder triggerBuilder = (TriggerBuilder)buildStep;
                    configs = triggerBuilder.getConfigs();
                    for (BuildTriggerConfig config : configs) {
                        result.addAll(config.getProjectList(project.getParent(), null));
                    }
                }
            }
        }
        for (Job job : result) {
            RunList builds = job.getBuilds();
            for (Run b : builds) {
                Cause.UpstreamCause cause = (Cause.UpstreamCause)b.getCause(Cause.UpstreamCause.class);
                if (cause == null || cause.getUpstreamBuild() != r.getNumber()) continue;
                runs.add(b);
            }
        }
        return runs;
    }
}

