/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildgraphview;

import com.cloudbees.plugins.flow.FlowCause;
import com.cloudbees.plugins.flow.FlowRun;
import com.cloudbees.plugins.flow.JobInvocation;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jenkinsci.plugins.buildgraphview.DownStreamRunDeclarer;

public class FlowDownStreamRunDeclarer
extends DownStreamRunDeclarer {
    @Override
    public List<Run> getDownStream(Run r) throws ExecutionException, InterruptedException {
        if (r instanceof FlowRun) {
            FlowRun f = (FlowRun)r;
            return this.getOutgoingEdgeRuns(f, f.getStartJob());
        }
        List<Run> runs = Collections.emptyList();
        FlowCause cause = (FlowCause)r.getCause(FlowCause.class);
        while (runs.isEmpty() && cause != null) {
            FlowRun f = cause.getFlowRun();
            runs = this.getOutgoingEdgeRuns(f, cause.getAssociatedJob());
            cause = (FlowCause)cause.getFlowRun().getCause(FlowCause.class);
        }
        return runs;
    }

    private List<Run> getOutgoingEdgeRuns(FlowRun f, JobInvocation start) throws ExecutionException, InterruptedException {
        Set edges = f.getJobsGraph().outgoingEdgesOf((Object)start);
        ArrayList<Run> runs = new ArrayList<Run>(edges.size());
        for (FlowRun.JobEdge edge : edges) {
            Run run;
            JobInvocation targetJobEdge = edge.getTarget();
            if (!targetJobEdge.isStarted() || (run = targetJobEdge.getBuild()) == null) continue;
            runs.add(run);
        }
        return runs;
    }
}

