/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildgraphview;

import com.google.gson.Gson;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Run;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jenkinsci.plugins.buildgraphview.BuildExecution;
import org.jenkinsci.plugins.buildgraphview.BuildGraphApi;
import org.jenkinsci.plugins.buildgraphview.BuildGraphColumnsNodeModel;
import org.jenkinsci.plugins.buildgraphview.BuildGraphConnectorModel;
import org.jenkinsci.plugins.buildgraphview.BuildGraphModel;
import org.jenkinsci.plugins.buildgraphview.BuildGraphNodeModel;
import org.jenkinsci.plugins.buildgraphview.DownStreamRunDeclarer;
import org.jenkinsci.plugins.buildgraphview.FlowDownStreamRunDeclarer;
import org.jenkinsci.plugins.buildgraphview.JenkinsUtil;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class BuildGraph
implements Action {
    private DirectedGraph<BuildExecution, Edge> graph;
    private BuildExecution start;
    private transient int index = 0;

    public BuildGraph(AbstractBuild run) {
        this.start = new BuildExecution((Run)run, 0);
    }

    public String getIconFileName() {
        return "/plugin/buildgraph-view/images/16x16/chain.png";
    }

    public String getDisplayName() {
        return "Build Graph";
    }

    public String getUrlName() {
        return "BuildGraph";
    }

    public BuildExecution getStart() {
        return this.start;
    }

    public String getBuildUrl() {
        return this.start.getBuildUrl();
    }

    public Api getApi() {
        return new BuildGraphApi(this);
    }

    private DirectedGraph<BuildExecution, Edge> getGraph() throws ExecutionException, InterruptedException, ClassNotFoundException, IOException {
        if (this.graph == null) {
            this.graph = new SimpleDirectedGraph(Edge.class);
            this.graph.addVertex((Object)this.start);
            this.index = 0;
            this.computeGraphFrom(this.start);
            this.setupDisplayGrid();
        }
        return this.graph;
    }

    private void computeGraphFrom(BuildExecution b) throws ExecutionException, InterruptedException, IOException {
        Run<?, ?> run = b.getBuild();
        List<DownStreamRunDeclarer> all = DownStreamRunDeclarer.all();
        if (JenkinsUtil.getInstance().getPlugin("build-flow-plugin") != null) {
            FlowDownStreamRunDeclarer declarer = new FlowDownStreamRunDeclarer();
            List<Run> runs = ((DownStreamRunDeclarer)declarer).getDownStream(run);
            for (Run r : runs) {
                if (r == null) continue;
                BuildExecution next = this.getExecution(r);
                this.graph.addVertex((Object)next);
                this.graph.addEdge((Object)b, (Object)next, (Object)new Edge(b, next));
                this.computeGraphFrom(next);
            }
        }
        for (DownStreamRunDeclarer declarer : all) {
            List<Run> runs = declarer.getDownStream(run);
            for (Run r : runs) {
                if (r == null) continue;
                BuildExecution next = this.getExecution(r);
                this.graph.addVertex((Object)next);
                this.graph.addEdge((Object)b, (Object)next, (Object)new Edge(b, next));
                this.computeGraphFrom(next);
            }
        }
    }

    private BuildExecution getExecution(Run r) {
        for (BuildExecution buildExecution : this.graph.vertexSet()) {
            if (!buildExecution.getBuild().equals((Object)r)) continue;
            return buildExecution;
        }
        return new BuildExecution(r, ++this.index);
    }

    private void setupDisplayGrid() {
        List<List<BuildExecution>> allPaths = this.findAllPaths(this.start);
        Collections.sort(allPaths, new Comparator<List<BuildExecution>>(){

            @Override
            public int compare(List<BuildExecution> runs1, List<BuildExecution> runs2) {
                return runs2.size() - runs1.size();
            }
        });
        for (int row = allPaths.size() - 1; row >= 0; --row) {
            List<BuildExecution> path = allPaths.get(row);
            for (int column = 0; column < path.size(); ++column) {
                BuildExecution job = path.get(column);
                job.setDisplayColumn(Math.max(job.getDisplayColumn(), column));
                job.setDisplayRow(row + 1);
            }
        }
    }

    private List<List<BuildExecution>> findAllPaths(BuildExecution start) {
        LinkedList<List<BuildExecution>> allPaths = new LinkedList<List<BuildExecution>>();
        if (this.graph.outDegreeOf((Object)start) == 0) {
            LinkedList<BuildExecution> singlePath = new LinkedList<BuildExecution>();
            singlePath.add(start);
            allPaths.add(singlePath);
        } else {
            for (Edge edge : this.graph.outgoingEdgesOf((Object)start)) {
                List<List<BuildExecution>> allPathsFromTarget = this.findAllPaths(edge.getTarget());
                for (List<BuildExecution> path : allPathsFromTarget) {
                    path.add(0, start);
                }
                allPaths.addAll(allPathsFromTarget);
            }
        }
        return allPaths;
    }

    @Exported
    public String getBuildGraph() throws InterruptedException, ExecutionException, ClassNotFoundException, IOException {
        DirectedGraph<BuildExecution, Edge> iGraph = this.getGraph();
        BuildGraphModel buildGraphModel = new BuildGraphModel();
        ArrayList<BuildGraphNodeModel> buildGraphNodeModelArrayList = new ArrayList<BuildGraphNodeModel>();
        ArrayList<BuildGraphConnectorModel> buildGraphConnectorsModelArrayList = new ArrayList<BuildGraphConnectorModel>();
        for (BuildExecution item : iGraph.vertexSet()) {
            BuildGraphNodeModel buildGraphNodeModel = new BuildGraphNodeModel();
            buildGraphNodeModel.setNodeId(item.getId());
            buildGraphNodeModel.setBuildUrl(item.getBuildUrl());
            buildGraphNodeModel.setParameters(item.getParameters());
            buildGraphNodeModel.setRow(item.getDisplayRow());
            buildGraphNodeModel.setColumn(item.getDisplayColumn());
            buildGraphNodeModel.setColor(item.getIconColor().getHtmlBaseColor());
            buildGraphNodeModel.setTitle(item.getFullDisplayName());
            buildGraphNodeModel.setDescription(item.getDescription() != null ? item.getDescription() : "");
            buildGraphNodeModel.setStarted(item.isStarted());
            buildGraphNodeModel.setRunning(item.getBuild().isBuilding());
            int progress = 0;
            buildGraphNodeModel.setTimeStampString("");
            if (item.getBuild().isBuilding()) {
                progress = (int)Math.round(100.0 * (double)(System.currentTimeMillis() - item.getBuild().getTimestamp().getTimeInMillis()) / (double)item.getBuild().getEstimatedDuration());
                if (progress > 100) {
                    progress = 99;
                }
                buildGraphNodeModel.setTimeStampString(item.getBuild().getTimestampString());
                buildGraphModel.setBuilding(true);
            }
            buildGraphNodeModel.setProgress(progress);
            buildGraphNodeModel.setStatus(item.getbuildSummaryStatusString());
            buildGraphNodeModel.setStartTime(item.getStartTime());
            buildGraphNodeModel.setDuration(item.getDurationString());
            buildGraphNodeModel.setRootUrl(JenkinsUtil.getInstance().getRootUrl());
            buildGraphNodeModel.setClockpng(JenkinsUtil.getInstance().getRootUrl() + "/images/16x16/clock.png");
            buildGraphNodeModel.setHourglasspng(JenkinsUtil.getInstance().getRootUrl() + "/images/16x16/hourglass.png");
            buildGraphNodeModel.setTerminalpng(JenkinsUtil.getInstance().getRootUrl() + "/images/16x16/terminal.png");
            buildGraphNodeModelArrayList.add(buildGraphNodeModel);
        }
        ArrayList<BuildGraphColumnsNodeModel> buildGraphColumnsNodeModelArrayList = new ArrayList<BuildGraphColumnsNodeModel>();
        for (BuildGraphNodeModel node : buildGraphNodeModelArrayList) {
            BuildGraphColumnsNodeModel buildGraphColumnsNodeModel;
            if (node.getColumn() >= buildGraphColumnsNodeModelArrayList.size()) {
                buildGraphColumnsNodeModel = new BuildGraphColumnsNodeModel();
                ArrayList<BuildGraphNodeModel> buildGraphNodeModels = new ArrayList<BuildGraphNodeModel>();
                buildGraphNodeModels.add(node);
                buildGraphColumnsNodeModel.setNodes(buildGraphNodeModels);
                buildGraphColumnsNodeModelArrayList.add(buildGraphColumnsNodeModel);
                continue;
            }
            buildGraphColumnsNodeModel = (BuildGraphColumnsNodeModel)buildGraphColumnsNodeModelArrayList.get(node.getColumn());
            buildGraphColumnsNodeModel.getNodes().add(node);
        }
        for (Edge edge : iGraph.edgeSet()) {
            BuildGraphConnectorModel buildGraphConnectorModel = new BuildGraphConnectorModel();
            buildGraphConnectorModel.setSource(edge.getSource().getId());
            buildGraphConnectorModel.setTarget(edge.getTarget().getId());
            buildGraphConnectorsModelArrayList.add(buildGraphConnectorModel);
        }
        buildGraphModel.setNodesSize(buildGraphNodeModelArrayList.size());
        buildGraphModel.setNodes(buildGraphColumnsNodeModelArrayList);
        buildGraphModel.setConnectors(buildGraphConnectorsModelArrayList);
        Gson gson = new Gson();
        return gson.toJson((Object)buildGraphModel);
    }

    public static class Edge
    implements Serializable {
        private BuildExecution source;
        private BuildExecution target;

        public Edge(BuildExecution source, BuildExecution target) {
            this.source = source;
            this.target = target;
        }

        public BuildExecution getSource() {
            return this.source;
        }

        public BuildExecution getTarget() {
            return this.target;
        }

        public String toString() {
            return this.source.toString() + " -> " + this.target.toString();
        }
    }
}

