/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_publisher;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.build_publisher.BuildPublisher;
import hudson.plugins.build_publisher.HudsonInstance;
import hudson.plugins.build_publisher.StatusInfo;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class StatusAction
implements Action {
    private StatusInfo statusInfo;
    public static final String URL = "publishingStatus";
    private AbstractBuild owner;

    public StatusAction(StatusInfo status, AbstractBuild owner) {
        this.statusInfo = status;
        this.owner = owner;
    }

    public String getDisplayName() {
        return "Publishing status";
    }

    public String getIconFileName() {
        return null;
    }

    public String getIconName() {
        String baseDir = "/plugin/build-publisher/icons/48x48/";
        switch (this.statusInfo.state) {
            case FAILURE: 
            case FAILURE_PENDING: {
                return baseDir + "failure.png";
            }
            case INPROGRESS: {
                return baseDir + "in-progress.png";
            }
            case SUCCESS: {
                return baseDir + "success.png";
            }
            case PENDING: {
                return baseDir + "waiting.png";
            }
            case INTERRUPTED: {
                return baseDir + "interrupted.png";
            }
        }
        return null;
    }

    public String getUrlName() {
        return URL;
    }

    public void doPublishAgain(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        HudsonInstance instance = BuildPublisher.DESCRIPTOR.getHudsonInstanceForName(this.statusInfo.serverName);
        if (instance != null) {
            this.statusInfo.state = this.statusInfo.state == StatusInfo.State.FAILURE ? StatusInfo.State.FAILURE_PENDING : StatusInfo.State.PENDING;
            instance.publishBuild(this.owner, this.statusInfo);
        }
        rsp.forwardToPreviousPage(req);
    }

    public StatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    public static void setBuildStatusAction(AbstractBuild build, StatusInfo statusInfo) {
        if (statusInfo != null) {
            StatusAction.setBuildStatusAction(build, new StatusAction(statusInfo, build));
        }
    }

    public static void setBuildStatusAction(AbstractBuild build, StatusAction statusAction) {
        StatusAction.removeAction(build);
        if (statusAction != null) {
            build.addAction((Action)statusAction);
        }
        try {
            build.save();
        }
        catch (IOException e) {
            e.printStackTrace();
            HudsonInstance.LOGGER.severe(e.getMessage());
        }
    }

    public static StatusAction removeAction(AbstractBuild build) {
        StatusAction action = (StatusAction)build.getAction(StatusAction.class);
        if (action != null) {
            build.getActions().remove(action);
        }
        return action;
    }
}

