/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_publisher;

import hudson.Util;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.plugins.build_publisher.BuildPublisherPostAction;
import hudson.plugins.build_publisher.ExternalProjectProperty;
import hudson.plugins.build_publisher.HTTPBuildTransmitter;
import hudson.plugins.build_publisher.HudsonInstance;
import hudson.plugins.build_publisher.PostActionDescriptor;
import hudson.plugins.build_publisher.ServerFailureException;
import hudson.plugins.build_publisher.StatusAction;
import hudson.plugins.build_publisher.StatusInfo;
import hudson.plugins.build_publisher.ThreadState;
import java.io.IOException;
import java.util.logging.Level;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class PublisherThread
extends Thread {
    private AbstractBuild currentRequest = null;
    private volatile ThreadState state = ThreadState.IDLE;
    private final HudsonInstance hudsonInstance;

    PublisherThread(HudsonInstance hudsonInstance) {
        super("Hudson - Build-Publisher Thread for " + hudsonInstance.getName());
        this.hudsonInstance = hudsonInstance;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block7: while (true) {
            try {
                while (true) {
                    this.state = ThreadState.IDLE;
                    this.currentRequest = this.hudsonInstance.nextRequest();
                    project = this.currentRequest.getProject();
                    if (project.getBuildByNumber(this.currentRequest.number) == null) {
                        HudsonInstance.LOGGER.info("build does not exist " + this.currentRequest.getProject() + " build " + this.currentRequest.number);
                        info = new StatusInfo(StatusInfo.State.INTERRUPTED, "Build was removed", this.hudsonInstance.getName(), null);
                        this.hudsonInstance.removeRequest(this.currentRequest, info);
                        continue;
                    }
                    this.state = new ThreadState.Publishing(this.currentRequest);
                    StatusAction.setBuildStatusAction(this.currentRequest, new StatusInfo(StatusInfo.State.INPROGRESS, "Build is being transmitted", this.hudsonInstance.getName(), null));
                    try {
                        publicHudsonUrl = this.hudsonInstance.getUrl();
                        if (project instanceof MatrixConfiguration) {
                            projectURL = publicHudsonUrl + "job/" + Util.rawEncode((String)((MatrixConfiguration)project).getParent().getName());
                            if (!this.urlExists(projectURL)) {
                                HudsonInstance.LOGGER.log(Level.WARNING, "Build " + this.currentRequest.getNumber() + " of matrix configuration " + project.getName() + " couldn't be published: Parent project " + project.getParent().getFullName() + " doesn't exist on the remote instance.");
                                this.hudsonInstance.removeRequest(this.currentRequest, new StatusInfo(StatusInfo.State.INTERRUPTED, "The parent project doesn't exist on the remote instance. Please create it (e.g. by publishing parent matrix build) and try again.", this.hudsonInstance.getName(), null));
                            }
                            configuration = (MatrixConfiguration)project;
                            configurationUrl = projectURL + "/" + Util.rawEncode((String)configuration.getName());
                            if (!this.urlExists(configurationUrl)) {
                                HudsonInstance.LOGGER.info("crateing config " + configuration.getName());
                                method = new PostMethod(projectURL + "/postBuild/createConfiguration");
                                method.addParameter("name", configuration.getName());
                                this.executeMethod((HttpMethodBase)method);
                                responseHeader = method.getResponseHeader("X-configuration-created");
                                if (responseHeader == null) {
                                    HudsonInstance.LOGGER.warning("Failed to create configuration " + configuration.getName() + " for project " + project.getName());
                                }
                                this.submitConfig(configurationUrl + "/config.xml", (Job)configuration);
                            }
                        } else {
                            this.synchronizeProjectSettings(publicHudsonUrl, project);
                        }
                        this.hudsonInstance.buildTransmitter.sendBuild(this.currentRequest, this.hudsonInstance);
                        if (this.currentRequest instanceof MavenModuleSetBuild) {
                            for (MavenBuild moduleBuild : ((MavenModuleSetBuild)this.currentRequest).getModuleLastBuilds().values()) {
                                this.hudsonInstance.buildTransmitter.sendBuild((AbstractBuild)moduleBuild, this.hudsonInstance);
                            }
                        } else if (this.currentRequest instanceof MatrixBuild) {
                            for (MatrixRun run : ((MatrixBuild)this.currentRequest).getRuns()) {
                                if (run == null) continue;
                                this.hudsonInstance.publishNewBuild((AbstractBuild)run);
                            }
                        }
                        this.runPostActions(this.currentRequest);
                        HudsonInstance.LOGGER.info("Build #" + this.currentRequest.getNumber() + " of project " + this.currentRequest.getProject().getName() + " was published.");
                        this.hudsonInstance.removeRequest(this.currentRequest, new StatusInfo(StatusInfo.State.SUCCESS, "Build transmission was successfully completed", this.hudsonInstance.getName(), null));
                        continue block7;
                    }
                    catch (Exception e) {
                        HudsonInstance.LOGGER.log(Level.WARNING, "Error during build transmission: " + e.getMessage(), e);
                        StatusAction.setBuildStatusAction(this.currentRequest, new StatusInfo(StatusInfo.State.FAILURE_PENDING, "Error during build publishing", this.hudsonInstance.getName(), e));
                        this.hudsonInstance.postponeRequest(this.currentRequest);
                        httpMethod = null;
                        if (e instanceof ServerFailureException) {
                            httpMethod = ((ServerFailureException)e).getMethod();
                        }
                        timeout = System.currentTimeMillis() + 600000L;
                        this.state = new ThreadState.ErrorRecoveryWait(timeout, this.currentRequest, e, httpMethod);
                        try {
                            while (true) {
                                if (System.currentTimeMillis() < timeout) ** break;
                                continue block7;
                                Thread.sleep(timeout - System.currentTimeMillis());
                            }
                        }
                        catch (InterruptedException e1) {
                            HudsonInstance.LOGGER.log(Level.SEVERE, "Build publisher thread was interrupted", e1);
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Error e) {
                this.state = new ThreadState.Dead(e);
                throw e;
            }
            catch (RuntimeException e) {
                this.state = new ThreadState.Dead(e);
                throw e;
            }
            break;
        }
    }

    public ThreadState getCurrentState() {
        return this.state;
    }

    private void runPostActions(AbstractBuild build) {
        for (PostActionDescriptor descriptor : BuildPublisherPostAction.POST_ACTIONS) {
            BuildPublisherPostAction action = descriptor.newInstance();
            if (action == null) continue;
            action.post(build, this.hudsonInstance);
        }
    }

    private void synchronizeProjectSettings(String publicHudson, AbstractProject project) throws IOException, ServerFailureException {
        block4: {
            block5: {
                block3: {
                    this.assertUrlExists(publicHudson);
                    ExternalProjectProperty.applyToProject(project);
                    this.createOrSynchronize(publicHudson, project);
                    if (!(project instanceof MavenModuleSet)) break block3;
                    String parentURL = publicHudson + "job/" + Util.rawEncode((String)project.getName());
                    for (MavenModule module : ((MavenModuleSet)project).getItems()) {
                        String moduleModuleSystemName = module.getModuleName().toFileSystemName();
                        this.submitConfig(parentURL + "/postBuild/acceptMavenModule?name=" + Util.rawEncode((String)moduleModuleSystemName), (Job)module);
                    }
                    break block4;
                }
                if (!(project instanceof MatrixProject)) break block5;
                String parentURL = publicHudson + "job/" + Util.rawEncode((String)project.getName());
                for (MatrixConfiguration configuration : ((MatrixProject)project).getActiveConfigurations()) {
                    this.submitConfig(parentURL + "/" + Util.rawEncode((String)configuration.getName()) + "/config.xml", (Job)configuration);
                }
                break block4;
            }
            if (!(project instanceof ItemGroup)) break block4;
            String parentURL = publicHudson + "job/" + Util.rawEncode((String)project.getName());
            for (Object item : ((ItemGroup)project).getItems()) {
                if (!(item instanceof Job)) continue;
                Job job = (Job)item;
                this.submitConfig(parentURL + "/" + job.getShortUrl() + "config.xml", job);
            }
        }
    }

    private void createOrSynchronize(String publicHudson, AbstractProject project) throws IOException, ServerFailureException {
        String projectURL = publicHudson + "job/" + Util.rawEncode((String)project.getName());
        String submitConfigUrl = !this.urlExists(projectURL) ? publicHudson + "createItem?name=" + Util.rawEncode((String)project.getName()) : projectURL + "/config.xml";
        this.submitConfig(submitConfigUrl, (Job)project);
    }

    private void submitConfig(String submitConfigUrl, Job project) throws IOException, ServerFailureException {
        PostMethod method = new PostMethod(submitConfigUrl);
        method.setRequestEntity((RequestEntity)new FileRequestEntity(project.getConfigFile().getFile(), "text/xml"));
        this.executeMethod((HttpMethodBase)method);
    }

    private void assertUrlExists(String url) throws IOException, ServerFailureException {
        this.executeMethod((HttpMethodBase)new PostMethod(url));
    }

    private boolean urlExists(String url) throws ServerFailureException, IOException {
        PostMethod method = new PostMethod(url);
        try {
            this.executeMethod((HttpMethodBase)method);
            return true;
        }
        catch (ServerFailureException e) {
            if (e.getMethod().getStatusLine() == null) {
                throw e;
            }
            int statusCode = e.getMethod().getStatusCode();
            if (statusCode == 400 || statusCode == 404) {
                return false;
            }
            throw e;
        }
    }

    private HttpMethod executeMethod(HttpMethodBase method) throws ServerFailureException {
        return HTTPBuildTransmitter.executeMethod(method, this.hudsonInstance);
    }
}

