/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_publisher;

import hudson.Util;
import hudson.matrix.Combination;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.maven.MavenModule;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Project;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.build_publisher.BuildPublisher;
import hudson.plugins.build_publisher.StatusAction;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.LogRotator;
import hudson.triggers.TriggerDescriptor;
import hudson.util.IOException2;
import hudson.util.LogTaskListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Untar;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ExternalProjectProperty
extends JobProperty<Job<?, ?>>
implements ProminentProjectAction {
    private static final Logger LOGGER = Logger.getLogger(ExternalProjectProperty.class.getName());
    private transient AbstractProject<?, ?> project;
    public static final ExternalProjectPropertyDescriptor DESCRIPTOR = new ExternalProjectPropertyDescriptor();

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public ProminentProjectAction getJobAction(Job<?, ?> job) {
        this.project = (AbstractProject)job;
        return this;
    }

    public void doCreateConfiguration(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.project.checkPermission(Job.CONFIGURE);
        String configuration = req.getParameter("name");
        if (this.project instanceof MatrixProject) {
            MatrixProject matrixProject = (MatrixProject)this.project;
            MatrixConfiguration config = matrixProject.getItem(configuration);
            if (config == null) {
                config = new MatrixConfiguration(matrixProject, Combination.fromString((String)configuration));
                try {
                    config.save();
                    ExternalProjectProperty.reloadProject(this.project);
                    rsp.setHeader("X-configuration-created", config.getName());
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "Failed to create configuration " + configuration + " for matrix project " + this.project.getName(), ex);
                }
            }
        } else {
            rsp.sendError(400, "Not a matirx job");
        }
    }

    public void doAcceptMavenModule(StaplerRequest req, StaplerResponse rsp) throws IOException {
        ExternalProjectProperty.acceptChildProject(req, rsp, this.project, "modules");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void acceptChildProject(StaplerRequest req, StaplerResponse rsp, AbstractProject project, String subDir) throws IOException {
        project.checkPermission(Job.CONFIGURE);
        String name = req.getParameter("name").trim();
        File modulesDir = new File(project.getRootDir(), subDir);
        File moduleDir = new File(modulesDir, name);
        moduleDir.mkdirs();
        File configFile = new File(moduleDir, "config.xml");
        try {
            FileOutputStream fos = new FileOutputStream(configFile);
            try {
                Util.copyStream((InputStream)req.getInputStream(), (OutputStream)fos);
                project.onLoad(project.getParent(), project.getName());
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            LOGGER.severe("Failed to accept child project " + name + " for " + project.getName() + e.getMessage());
            throw e;
        }
    }

    public void doAcceptBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, InterruptedException {
        this.project.checkPermission(Job.CONFIGURE);
        HashSet<String> oldBuildIDs = new HashSet<String>();
        for (Run run : this.project.getBuilds()) {
            oldBuildIDs.add(run.getId());
        }
        File buildsDir = Jenkins.getInstance().getBuildDirFor(this.project);
        Untar untar = new Untar();
        untar.setProject(new org.apache.tools.ant.Project());
        untar.add((ResourceCollection)new InputStreamResource(this.project.getName(), new BufferedInputStream((InputStream)req.getInputStream())));
        untar.setDest(buildsDir);
        untar.setOverwrite(true);
        if (BuildPublisher.DESCRIPTOR.getRemoveTriggers()) {
            this.removeTriggers(this.project);
        }
        String buildNumber = req.getHeader("X-Build-Number");
        try {
            Run bid;
            untar.execute();
            ExternalProjectProperty.reloadProject(this.project);
            for (Run build : this.project.getBuilds()) {
                StatusAction statusAction = (StatusAction)build.getAction(StatusAction.class);
                if (statusAction == null) continue;
                build.getActions().remove(statusAction);
                build.save();
            }
            AbstractBuild lastBuild = this.project.getLastBuild();
            int nextBuildNumber = (lastBuild != null ? lastBuild.number : 0) + 1;
            this.project.updateNextBuildNumber(nextBuildNumber);
            if (lastBuild.getResult() == Result.SUCCESS && (bid = this.project.getLastStableBuild()) != null && Integer.parseInt(buildNumber) >= bid.number) {
                Util.createSymlink((File)buildsDir, (String)buildNumber, (String)"lastStableBuild", (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
            }
            if (lastBuild.getResult().isBetterOrEqualTo(Result.UNSTABLE) && (bid = this.project.getLastSuccessfulBuild()) != null && Integer.parseInt(buildNumber) >= bid.number) {
                Util.createSymlink((File)buildsDir, (String)buildNumber, (String)"lastSuccessfulBuild", (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
            }
            if (lastBuild.getResult() == Result.FAILURE && (bid = this.project.getLastFailedBuild()) != null && Integer.parseInt(buildNumber) >= bid.number) {
                Util.createSymlink((File)buildsDir, (String)buildNumber, (String)"lastFailedBuild", (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
            }
            if (lastBuild.getResult() == Result.UNSTABLE && (bid = this.project.getLastUnstableBuild()) != null && Integer.parseInt(buildNumber) >= bid.number) {
                Util.createSymlink((File)buildsDir, (String)buildNumber, (String)"lastUnstableBuild", (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
            }
            if (lastBuild.getResult() != Result.SUCCESS && (bid = this.project.getLastUnsuccessfulBuild()) != null && Integer.parseInt(buildNumber) >= bid.number) {
                Util.createSymlink((File)buildsDir, (String)buildNumber, (String)"lastUnsuccessfulBuild", (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
            }
            rsp.addHeader("X-Build-Recieved", this.project.getName());
            try {
                this.tidyUp();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Cleaning project " + this.project.getName() + "failed: " + e.getMessage(), e);
            }
        }
        catch (BuildException e) {
            LOGGER.log(Level.SEVERE, "Failed to read the remote stream " + this.project.getName() + e.getMessage(), e);
            throw new IOException2("Failed to read the remote stream " + this.project.getName(), (Throwable)e);
        }
    }

    private void removeTriggers(AbstractProject<?, ?> project) throws IOException {
        for (TriggerDescriptor trigger : project.getTriggers().keySet()) {
            project.removeTrigger(trigger);
        }
        project.save();
    }

    private void tidyUp() throws IOException, InterruptedException {
        AbstractBuild build;
        ArtifactArchiver archiver;
        BuildPublisher publisher = (BuildPublisher)this.project.getPublishersList().get((Descriptor)BuildPublisher.DESCRIPTOR);
        if (publisher != null) {
            LogRotator rotator = publisher.getLogRotator();
            if (rotator != null) {
                rotator.perform(this.project);
            } else {
                this.project.logRotate();
            }
        }
        if (this.project instanceof Project && (archiver = (ArtifactArchiver)this.project.getPublishersList().get(ArtifactArchiver.class)) != null && archiver.isLatestOnly() && (build = (AbstractBuild)this.project.getLastSuccessfulBuild()) != null) {
            while ((build = build.getPreviousBuild()) != null) {
                File ad = build.getArtifactsDir();
                if (!ad.exists()) continue;
                LOGGER.info("Deleting old artifacts from " + build.getDisplayName());
                Util.deleteRecursive((File)ad);
            }
        }
    }

    private static void reloadProject(AbstractProject project) throws IOException {
        if (project instanceof MavenModule) {
            project.onLoad(project.getParent(), ((MavenModule)project).getModuleName().toFileSystemName());
        } else {
            project.onLoad(project.getParent(), project.getName());
        }
    }

    public static void applyToProject(Job<?, ?> job) throws IOException {
        if (job instanceof ItemGroup) {
            for (Object item : ((ItemGroup)job).getItems()) {
                ExternalProjectProperty.applyToProject((Job)item);
            }
        }
        for (JobProperty prop : job.getProperties().values()) {
            if (!prop.getClass().getName().equals("hudson.plugins.build_publisher.ExternalProjectProperty")) continue;
            return;
        }
        job.addProperty((JobProperty)new ExternalProjectProperty());
    }

    public String getDisplayName() {
        return DESCRIPTOR.getDisplayName();
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "postBuild";
    }

    public static class ExternalProjectPropertyDescriptor
    extends JobPropertyDescriptor {
        public ExternalProjectPropertyDescriptor() {
            super(ExternalProjectProperty.class);
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return false;
        }

        public String getDisplayName() {
            return "Post remote build";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return null;
        }
    }

    private static class InputStreamResource
    extends Resource {
        private final InputStream in;

        public InputStreamResource(String name, InputStream in) {
            this.in = in;
            this.setName(name);
        }

        public InputStream getInputStream() throws IOException {
            return this.in;
        }
    }
}

