/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_publisher;

import hudson.Util;
import hudson.model.AbstractBuild;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class ThreadState {
    public static final ThreadState IDLE = new Idle();

    private ThreadState() {
    }

    static String printStackTrace(Throwable cause) {
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static class Publishing
    extends ThreadState {
        public final AbstractBuild build;

        Publishing(AbstractBuild build) {
            this.build = build;
        }
    }

    public static class Dead
    extends ThreadState {
        public final Throwable cause;

        Dead(Throwable cause) {
            this.cause = cause;
        }

        public String getStackTrace() {
            return Dead.printStackTrace(this.cause);
        }
    }

    public static class Idle
    extends ThreadState {
        private Idle() {
        }
    }

    public static class ErrorRecoveryWait
    extends ThreadState {
        public final long timeout;
        public final Throwable cause;
        public final AbstractBuild build;
        public final HttpMethod method;

        ErrorRecoveryWait(long timeout, AbstractBuild build, Throwable cause, HttpMethod method) {
            this.timeout = timeout;
            this.build = build;
            this.cause = cause;
            this.method = method;
        }

        public String getTimeoutString() {
            return Util.getTimeSpanString((long)(this.timeout - System.currentTimeMillis()));
        }

        public String getStackTrace() {
            return ErrorRecoveryWait.printStackTrace(this.cause);
        }

        public void doOutput(StaplerRequest req, StaplerResponse rsp) throws IOException {
            if (this.method == null) {
                rsp.sendError(404);
            } else {
                Header ct = this.method.getResponseHeader("Content-type");
                if (ct != null) {
                    rsp.setContentType(ct.getValue());
                } else {
                    rsp.setContentType("text/plain;charset=UTF-8");
                }
                rsp.getWriter().write(this.method.getResponseBodyAsString());
            }
        }
    }
}

