/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_publisher;

import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import hudson.plugins.build_publisher.BuildTransmitter;
import hudson.plugins.build_publisher.HTTPBuildTransmitter;
import hudson.plugins.build_publisher.PublisherThread;
import hudson.plugins.build_publisher.StatusAction;
import hudson.plugins.build_publisher.StatusInfo;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpClientParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HudsonInstance {
    static final Logger LOGGER = Logger.getLogger(Hudson.class.getName());
    private String url;
    private String name;
    private String login;
    private String password;
    private transient LinkedHashSet<AbstractBuild> publishRequestQueue = new LinkedHashSet();
    private transient PublisherThread publisherThread;
    transient BuildTransmitter buildTransmitter;
    private transient HttpClient client;

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean requiresAuthentication() {
        return Util.fixEmpty((String)this.login) != null;
    }

    public HudsonInstance(String name, String url, String login, String password) {
        this.name = name;
        this.url = url;
        this.login = login;
        this.password = password;
        this.initVariables();
        this.restoreQueue();
        this.initPublisherThread();
    }

    public String getUrl() {
        if (this.url != null && !this.url.endsWith("/")) {
            this.url = this.url + '/';
        }
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public void publishNewBuild(AbstractBuild build) {
        this.publishBuild(build, new StatusInfo(StatusInfo.State.PENDING, "Waiting in queue", this.name, null));
    }

    public synchronized void publishBuild(AbstractBuild build, StatusInfo status) {
        this.publishRequestQueue.add(build);
        StatusAction.setBuildStatusAction(build, status);
        this.saveQueue();
        this.notifyAll();
    }

    private Object readResolve() {
        this.initVariables();
        Hudson.getInstance().getExtensionList(ItemListener.class).add((Object)new ItemListener(){

            public void onLoaded() {
                HudsonInstance.this.restoreQueue();
                HudsonInstance.this.initPublisherThread();
            }
        });
        return this;
    }

    private void initVariables() {
        this.publishRequestQueue = new LinkedHashSet();
        this.buildTransmitter = new HTTPBuildTransmitter();
        SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager();
        HttpClientParams params = new HttpClientParams();
        params.setSoTimeout(600000);
        this.client = new HttpClient(params, (HttpConnectionManager)connectionManager);
        this.loadProxy();
    }

    public void loadProxy() {
        ProxyConfiguration proxy;
        Jenkins j = Jenkins.getInstance();
        ProxyConfiguration proxyConfiguration = proxy = j != null ? j.proxy : null;
        if (proxy != null) {
            this.client.getHostConfiguration().setProxy(proxy.name, proxy.port);
            if (proxy.getUserName() != null) {
                this.client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxy.getUserName(), proxy.getPassword()));
            }
        }
    }

    void initPublisherThread() {
        if (this.publisherThread == null || !this.publisherThread.isAlive()) {
            this.publisherThread = new PublisherThread(this);
            this.publisherThread.start();
        }
    }

    void setCredentialsFroClient(HttpClient httpClient) {
        try {
            URL sunUrl = new URL(this.url);
            if (this.login != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.login, this.password);
                httpClient.getState().setCredentials(new AuthScope(sunUrl.getHost(), -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)credentials);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            LOGGER.severe(e.getMessage());
        }
    }

    HttpClient getHttpClient() {
        return this.client;
    }

    synchronized void removeRequest(AbstractBuild request, StatusInfo statusInfo) {
        if (this.publishRequestQueue.contains(request)) {
            this.publishRequestQueue.remove(request);
            this.saveQueue();
            StatusAction.setBuildStatusAction(request, statusInfo);
        }
    }

    synchronized void postponeRequest(AbstractBuild request) {
        if (this.publishRequestQueue.contains(request)) {
            this.publishRequestQueue.remove(request);
            this.publishRequestQueue.add(request);
        }
    }

    public synchronized List<AbstractBuild> getQueue() {
        return new ArrayList<AbstractBuild>(this.publishRequestQueue);
    }

    public PublisherThread getPublisherThread() {
        return this.publisherThread;
    }

    synchronized AbstractBuild nextRequest() {
        this.waitForRequest();
        return (AbstractBuild)this.publishRequestQueue.iterator().next();
    }

    private void waitForRequest() {
        while (this.publishRequestQueue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private void saveQueue() {
        LinkedList<RequestHolder> holders = new LinkedList<RequestHolder>();
        for (AbstractBuild request : this.publishRequestQueue) {
            int n = request.getNumber();
            AbstractProject p = request.getProject();
            RequestHolder holder = new RequestHolder(n, p.getFullName());
            holders.add(holder);
        }
        XmlFile file = new XmlFile(new File(Hudson.getInstance().getRootDir(), "bp-" + this.name + ".xml"));
        try {
            file.write(holders);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.severe(e.getMessage());
        }
    }

    private void restoreQueue() {
        XmlFile file = new XmlFile(new File(Hudson.getInstance().getRootDir(), "bp-" + this.name + ".xml"));
        if (!file.exists()) {
            return;
        }
        try {
            List holders = (List)file.read();
            for (RequestHolder holder : holders) {
                AbstractBuild build;
                String projectName = holder.project;
                Item project = Hudson.getInstance().getItemByFullName(projectName);
                if (!(project instanceof AbstractProject) || !((build = ((AbstractProject)project).getBuildByNumber(holder.build)) instanceof AbstractBuild)) continue;
                this.publishRequestQueue.add(build);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not restore publisher queue from " + file.getFile().getAbsolutePath(), e);
        }
    }

    private static class RequestHolder {
        int build;
        String project;

        public RequestHolder(int build, String project) {
            this.build = build;
            this.project = project;
        }
    }
}

