/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_publisher;

import hudson.Functions;
import hudson.Util;
import hudson.matrix.MatrixConfiguration;
import hudson.maven.MavenModule;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.build_publisher.BuildTransmitter;
import hudson.plugins.build_publisher.HudsonInstance;
import hudson.plugins.build_publisher.ServerFailureException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class HTTPBuildTransmitter
implements BuildTransmitter {
    private PostMethod method;
    private boolean aborted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBuild(AbstractBuild build, HudsonInstance hudsonInstance) throws ServerFailureException {
        this.aborted = false;
        AbstractProject project = build.getProject();
        String jobUrl = "job/";
        jobUrl = project instanceof MavenModule ? jobUrl + Util.rawEncode((String)((MavenModule)project).getParent().getName()) + "/" + Util.rawEncode((String)((MavenModule)project).getModuleName().toFileSystemName()) : (project instanceof MatrixConfiguration ? jobUrl + Util.rawEncode((String)((MatrixConfiguration)project).getParent().getName()) + "/" + Util.rawEncode((String)((MatrixConfiguration)project).getCombination().toString()) : jobUrl + Util.rawEncode((String)project.getName()));
        this.method = new PostMethod(hudsonInstance.getUrl() + jobUrl + "/postBuild/acceptBuild");
        File tempFile = null;
        OutputStream out = null;
        try {
            tempFile = File.createTempFile("hudson_bp", ".tar");
            out = new FileOutputStream(tempFile);
            this.writeToTar(out, build);
            this.method.setRequestEntity((RequestEntity)new FileRequestEntity(tempFile, "application/x-tar"));
            this.method.setRequestHeader("X-Build-Number", String.valueOf(build.getNumber()));
            HTTPBuildTransmitter.executeMethod((HttpMethodBase)this.method, hudsonInstance);
            Header responseHeader = this.method.getResponseHeader("X-Build-Recieved");
            if (responseHeader == null || !project.getName().equals(responseHeader.getValue().trim())) {
                throw new HttpException("Remote instance didn't confirm recieving this build");
            }
        }
        catch (IOException e) {
            if (!this.aborted) {
                throw new ServerFailureException((HttpMethod)this.method, e);
            }
        }
        catch (RuntimeException e1) {
            if (!this.aborted) {
                throw e1;
            }
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    HudsonInstance.LOGGER.log(Level.SEVERE, "Failed to close stream for file " + tempFile.getAbsolutePath());
                }
            }
            if (!tempFile.delete()) {
                HudsonInstance.LOGGER.log(Level.SEVERE, "Failed to delete temporary file " + tempFile.getAbsolutePath() + ". Please delete the file manually.");
            }
        }
    }

    public void abortTransmission() {
        this.aborted = true;
        if (this.method != null) {
            this.method.abort();
        }
    }

    static HttpMethod executeMethod(HttpMethodBase method, HudsonInstance hudsonInstance) throws ServerFailureException {
        hudsonInstance.getHttpClient().getState().clear();
        if (hudsonInstance.requiresAuthentication()) {
            GetMethod loginMethod = new GetMethod(hudsonInstance.getUrl() + "login");
            HTTPBuildTransmitter.followRedirects((HttpMethodBase)loginMethod, hudsonInstance);
            try {
                HTTPBuildTransmitter.login("j_security_check", hudsonInstance);
            }
            catch (ServerFailureException original) {
                try {
                    HTTPBuildTransmitter.login("j_acegi_security_check", hudsonInstance);
                }
                catch (ServerFailureException acegy) {
                    throw acegy.getMethod().getStatusCode() == 404 ? original : acegy;
                }
            }
        }
        return HTTPBuildTransmitter.followRedirects(method, hudsonInstance);
    }

    private static void login(String type, HudsonInstance hudsonInstance) throws ServerFailureException {
        PostMethod servletSecurityMethod = new PostMethod(hudsonInstance.getUrl() + type);
        servletSecurityMethod.addParameter("j_username", hudsonInstance.getLogin());
        servletSecurityMethod.addParameter("j_password", hudsonInstance.getPassword());
        servletSecurityMethod.addParameter("action", "login");
        HTTPBuildTransmitter.followRedirects((HttpMethodBase)servletSecurityMethod, hudsonInstance);
    }

    private static HttpMethod followRedirects(HttpMethodBase method, HudsonInstance hudsonInstance) throws ServerFailureException {
        HttpClient client = hudsonInstance.getHttpClient();
        try {
            Header locationHeader;
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode < 300) {
                HttpMethodBase httpMethodBase = method;
                return httpMethodBase;
            }
            if (statusCode < 400 && (locationHeader = method.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                method.setURI(new URI(redirectLocation, true));
                HttpMethod httpMethod = HTTPBuildTransmitter.followRedirects(method, hudsonInstance);
                return httpMethod;
            }
            try {
                throw new ServerFailureException((HttpMethod)method);
            }
            catch (IOException ioe) {
                throw new ServerFailureException((HttpMethod)method, ioe);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private Integer writeToTar(OutputStream out, AbstractBuild build) throws IOException {
        String[] files;
        File buildDir = build.getRootDir();
        File baseDir = buildDir.getParentFile();
        String buildXmlFile = buildDir.getName() + "/build.xml";
        FileSet fileSet = new FileSet();
        fileSet.setDir(baseDir);
        fileSet.setIncludes(buildDir.getName() + "/**");
        fileSet.setExcludes(buildXmlFile);
        byte[] buffer = new byte[8192];
        TarOutputStream tar = new TarOutputStream((OutputStream)new BufferedOutputStream(out));
        tar.setLongFileMode(2);
        DirectoryScanner dirScanner = fileSet.getDirectoryScanner(new Project());
        for (String fileName : files = dirScanner.getIncludedFiles()) {
            File file;
            if (this.aborted) break;
            if (Functions.isWindows()) {
                fileName = fileName.replace('\\', '/');
            }
            if ((file = new File(baseDir, fileName)).isDirectory()) continue;
            this.writeStreamToTar(tar, new FileInputStream(file), fileName, file.length(), buffer);
        }
        File buildFile = new File(build.getRootDir(), "build.xml");
        String buildXml = Util.loadFile((File)buildFile);
        byte[] bytes = buildXml.getBytes();
        this.writeStreamToTar(tar, new ByteArrayInputStream(bytes), buildXmlFile, bytes.length, buffer);
        tar.close();
        return files.length;
    }

    private void writeStreamToTar(TarOutputStream tar, InputStream in, String fileName, long length, byte[] buf) throws IOException {
        int len;
        TarEntry te = new TarEntry(fileName);
        te.setSize(length);
        tar.putNextEntry(te);
        while ((len = in.read(buf)) >= 0 && !this.aborted) {
            tar.write(buf, 0, len);
        }
        tar.closeEntry();
        in.close();
    }
}

