/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_publisher;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.plugins.build_publisher.BuildPublisher;
import hudson.plugins.build_publisher.HudsonInstance;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class BuildPublisherPlugin
extends Plugin {
    public HudsonInstance[] getHudsonInstances() {
        return BuildPublisher.DESCRIPTOR.getPublicInstances();
    }

    public HudsonInstance getInstance(int n) {
        return this.getHudsonInstances()[n];
    }

    public void doRetryNow(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="name") String name) throws IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        HudsonInstance h = BuildPublisher.DESCRIPTOR.getHudsonInstanceForName(name);
        if (h == null) {
            rsp.sendError(400, "No such name: " + name);
            return;
        }
        h.getPublisherThread().interrupt();
        rsp.sendRedirect(".");
    }

    public void doResurrect(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="name") String name) throws IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        HudsonInstance h = BuildPublisher.DESCRIPTOR.getHudsonInstanceForName(name);
        if (h == null) {
            rsp.sendError(400, "No such name: " + name);
            return;
        }
        h.initPublisherThread();
        rsp.sendRedirect(".");
    }

    public void doCheckHudsonUrl(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        new FormFieldValidator.HudsonURL(req, rsp).process();
    }

    @Extension
    public static class BuildPublisherManagementLink
    extends ManagementLink {
        public String getIconFileName() {
            return "redo.gif";
        }

        public String getUrlName() {
            return "plugin/build-publisher/";
        }

        public String getDisplayName() {
            return "Build Publishing Status";
        }

        public String getDescription() {
            return "Monitor the status of the <a href='http://wiki.hudson-ci.org/display/HUDSON/Build+Publisher+Plugin'>build-publisher plugin</a>";
        }
    }
}

