/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_publisher;

import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.plugins.build_publisher.BuildPublisherPostAction;
import hudson.plugins.build_publisher.HudsonInstance;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.LogRotator;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPublisher
extends Notifier
implements MatrixAggregatable {
    private String serverName;
    private String notificationRecipients;
    private boolean publishUnstableBuilds;
    private boolean publishFailedBuilds;
    private List<BuildPublisherPostAction> postActions = new Vector<BuildPublisherPostAction>();
    private LogRotator logRotator;
    private transient HudsonInstance publicHudsonInstance;
    @Extension
    public static final BuildPublisherDescriptor DESCRIPTOR = new BuildPublisherDescriptor();

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (!this.publishUnstableBuilds && Result.UNSTABLE == build.getResult() || !this.publishFailedBuilds && Result.FAILURE == build.getResult()) {
            return true;
        }
        if (build.getProject().getParent() != Hudson.getInstance()) {
            return true;
        }
        this.publicHudsonInstance = DESCRIPTOR.getHudsonInstanceForName(this.getServerName());
        if (this.publicHudsonInstance == null) {
            listener.getLogger().println("There is no public Hudson instance configured for this project");
            return true;
        }
        listener.getLogger().println("Build was marked for publishing on " + this.publicHudsonInstance.getUrl());
        this.publicHudsonInstance.publishNewBuild(build);
        return true;
    }

    public MatrixAggregator createAggregator(final MatrixBuild matrixBuild, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(matrixBuild, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                return BuildPublisher.this.perform((AbstractBuild)matrixBuild, this.launcher, this.listener);
            }
        };
    }

    public BuildPublisherDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public String getServerName() {
        HudsonInstance[] instances;
        if (this.serverName == null && (instances = DESCRIPTOR.getPublicInstances()) != null && instances.length == 1) {
            return instances[0].getName();
        }
        return this.serverName;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public String getNotificationRecipients() {
        return this.notificationRecipients;
    }

    public void setNotificationRecipients(String notificationRecipients) {
        this.notificationRecipients = notificationRecipients;
    }

    public void setPublishUnstableBuilds(boolean publishUnstableBuilds) {
        this.publishUnstableBuilds = publishUnstableBuilds;
    }

    public void setPublishFailedBuilds(boolean publishFailedBuilds) {
        this.publishFailedBuilds = publishFailedBuilds;
    }

    public boolean isPublishUnstableBuilds() {
        return this.publishUnstableBuilds;
    }

    public boolean isPublishFailedBuilds() {
        return this.publishFailedBuilds;
    }

    public void setServerName(String name) {
        this.serverName = name;
    }

    public HudsonInstance getPublicHudsonInstance() {
        return DESCRIPTOR.getHudsonInstanceForName(this.getServerName());
    }

    public Map<Descriptor<BuildPublisherPostAction>, BuildPublisherPostAction> getPostActions() {
        return Descriptor.toMap(this.postActions);
    }

    public LogRotator getLogRotator() {
        return this.logRotator;
    }

    public void setLogRotator(LogRotator logRotator) {
        this.logRotator = logRotator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BuildPublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        private HudsonInstance[] publicInstances = new HudsonInstance[0];
        private boolean removeTriggers;

        protected BuildPublisherDescriptor() {
            super(BuildPublisher.class);
            this.load();
        }

        protected void convert(Map<String, Object> oldPropertyBag) {
            if (oldPropertyBag.containsKey("publicInstances")) {
                this.publicInstances = (HudsonInstance[])oldPropertyBag.get("publicInstances");
            }
        }

        public String getDisplayName() {
            return "Publish build";
        }

        public void setRemoveTriggers(boolean removeTriggers) {
            this.removeTriggers = removeTriggers;
        }

        public boolean getRemoveTriggers() {
            return this.removeTriggers;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            BuildPublisher bp = new BuildPublisher();
            req.bindParameters((Object)bp, "bp.");
            if (req.getParameter("publicLogrotate") != null) {
                LogRotator.LRDescriptor desc = (LogRotator.LRDescriptor)Jenkins.getInstance().getDescriptor(LogRotator.class);
                bp.logRotator = (LogRotator)desc.newInstance(req, formData.getJSONObject("publicLogrotate"));
            } else {
                bp.logRotator = null;
            }
            return bp;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String[] names = req.getParameterValues("bp.name");
            String[] urls = req.getParameterValues("bp.url");
            String[] logins = req.getParameterValues("bp.login");
            String[] passwords = req.getParameterValues("bp.password");
            ArrayList<HudsonInstance> servers = new ArrayList<HudsonInstance>();
            for (int i = 0; i < names.length; ++i) {
                if (urls[i].length() == 0) continue;
                if (names[i].length() == 0) {
                    names[i] = urls[i];
                }
                servers.add(new HudsonInstance(names[i], urls[i], logins[i], passwords[i]));
            }
            this.publicInstances = servers.toArray(new HudsonInstance[0]);
            req.bindParameters((Object)this, "bp.server.");
            this.save();
            return true;
        }

        public HudsonInstance[] getPublicInstances() {
            return this.publicInstances;
        }

        public void setPublicInstances(HudsonInstance[] instaces) {
            this.publicInstances = instaces;
        }

        public HudsonInstance getHudsonInstanceForName(String name) {
            for (HudsonInstance server : this.publicInstances) {
                if (!server.getName().equals(name)) continue;
                return server;
            }
            return null;
        }

        public void doReloadProxy() {
            for (HudsonInstance server : this.publicInstances) {
                server.loadProxy();
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/build-publisher/help/config/publish.html";
        }
    }
}

