/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Build;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Publisher;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchProjectFactoryDescriptor;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyDescriptor;
import jenkins.branch.JobDecorator;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.branch.ProjectDecorator;
import org.jenkinsci.Symbol;
import org.jvnet.tiger_types.Types;
import org.kohsuke.stapler.DataBoundConstructor;

public class UntrustedBranchProperty
extends BranchProperty {
    private final Set<String> publisherWhitelist;

    @DataBoundConstructor
    public UntrustedBranchProperty(String[] publisherWhitelist) {
        this.publisherWhitelist = publisherWhitelist == null ? Collections.emptySet() : new TreeSet<String>(Arrays.asList(publisherWhitelist));
    }

    public Set<String> getPublisherWhitelist() {
        return Collections.unmodifiableSet(this.publisherWhitelist);
    }

    @Override
    public <P extends Job<P, B>, B extends Run<P, B>> JobDecorator<P, B> jobDecorator(Class<P> jobType) {
        if (Project.class.isAssignableFrom(jobType)) {
            return new Decorator();
        }
        return null;
    }

    @Symbol(value={"untrusted"})
    @Extension
    public static class DescriptorImpl
    extends BranchPropertyDescriptor {
        public String getDisplayName() {
            return "Untrusted";
        }

        public Map<String, Descriptor<Publisher>> getPublisherDescriptors() {
            LinkedHashMap<String, Descriptor<Publisher>> result = new LinkedHashMap<String, Descriptor<Publisher>>();
            for (Descriptor d : Publisher.all()) {
                result.put(d.clazz.getName(), (Descriptor<Publisher>)d);
            }
            return result;
        }

        @Override
        protected boolean isApplicable(MultiBranchProjectDescriptor projectDescriptor) {
            for (BranchProjectFactoryDescriptor d : projectDescriptor.getProjectFactoryDescriptors()) {
                Type factoryType = Types.getBaseClass((Type)d.clazz, BranchProjectFactory.class);
                Type jobType = Types.getTypeArgument((Type)factoryType, (int)0, Project.class);
                if (!Project.class.isAssignableFrom(Types.erasure((Type)jobType))) continue;
                return true;
            }
            return false;
        }
    }

    private class Decorator<P extends Project<P, B>, B extends Build<P, B>>
    extends ProjectDecorator<P, B> {
        private Decorator() {
        }

        @Override
        @NonNull
        public List<Publisher> publishers(@NonNull List<Publisher> publishers) {
            ArrayList<Publisher> result = new ArrayList<Publisher>();
            Set<String> whitelist = UntrustedBranchProperty.this.getPublisherWhitelist();
            if (!whitelist.isEmpty()) {
                for (Publisher publisher : publishers) {
                    if (!whitelist.contains(publisher.getDescriptor().clazz.getName())) continue;
                    result.add(publisher);
                }
            }
            return result;
        }

        @Override
        @NonNull
        public List<BuildWrapper> buildWrappers(@NonNull List<BuildWrapper> wrappers) {
            return super.buildWrappers(wrappers);
        }
    }
}

