/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.PluginWrapper;
import hudson.model.AdministrativeMonitor;
import hudson.model.UpdateSite;
import hudson.util.DescribableList;
import hudson.util.VersionNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jvnet.localizer.Localizable;

public abstract class PropertyMigration<F extends AbstractFolder<?>, P extends AbstractFolderProperty<F>>
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(PropertyMigration.class.getName());
    private final Class<F> folderClass;
    private final Class<P> propertyClass;
    private final String pluginName;
    private final String pluginVersion;

    public PropertyMigration(Class<F> folderClass, Class<P> propertyClass, String pluginName) {
        this.folderClass = folderClass;
        this.propertyClass = propertyClass;
        int index = pluginName.indexOf(58);
        this.pluginName = index == -1 ? pluginName : pluginName.substring(0, index);
        this.pluginVersion = index == -1 ? null : pluginName.substring(index + 1);
    }

    public final boolean isApplicable(AbstractFolder<?> folder) {
        return this.folderClass.isInstance(folder) && folder.getProperties().get(this.propertyClass) != null;
    }

    public final boolean canApply() {
        for (Migrator migrator : ExtensionList.lookup(Migrator.class)) {
            if (!this.folderClass.equals(migrator.folderClass) || !this.propertyClass.equals(migrator.propertyClass)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEnabled() {
        return true;
    }

    public final String getPluginName() {
        return this.pluginName;
    }

    public final String getPluginDisplayName() {
        UpdateSite.Plugin plugin = Jenkins.get().getUpdateCenter().getPlugin(this.pluginName);
        return plugin == null ? this.pluginName : plugin.getDisplayName();
    }

    public final String getPluginInstallId() {
        UpdateSite.Plugin plugin = Jenkins.get().getUpdateCenter().getPlugin(this.pluginName);
        if (this.pluginVersion != null) {
            VersionNumber versionNumber;
            VersionNumber versionNumber2 = versionNumber = plugin == null ? null : new VersionNumber(plugin.version);
            if (new VersionNumber(this.pluginVersion).isNewerThan(versionNumber)) {
                return null;
            }
        }
        return plugin == null ? null : "plugin." + this.pluginName + "." + plugin.sourceId;
    }

    public final String getPluginVersion() {
        return this.pluginVersion;
    }

    public final boolean isPendingRestart() {
        PluginWrapper plugin = Jenkins.get().getPluginManager().getPlugin(this.pluginName);
        return plugin != null && !plugin.isActive() && plugin.isEnabled();
    }

    public final boolean isPluginUpgrade() {
        PluginWrapper plugin = Jenkins.get().getPluginManager().getPlugin(this.pluginName);
        VersionNumber versionNumber = plugin == null ? null : plugin.getVersionNumber();
        return this.pluginVersion != null && versionNumber != null && new VersionNumber(this.pluginVersion).isNewerThan(versionNumber);
    }

    public abstract Localizable getDescription();

    public final void apply(AbstractFolder<?> folder) {
        if (!this.folderClass.isInstance(folder)) {
            throw new IllegalArgumentException();
        }
        AbstractFolder f = (AbstractFolder)this.folderClass.cast(folder);
        AbstractFolderProperty p = (AbstractFolderProperty)f.getProperties().get(this.propertyClass);
        if (p == null) {
            throw new IllegalArgumentException();
        }
        for (Migrator migrator : ExtensionList.lookup(Migrator.class)) {
            if (!this.folderClass.equals(migrator.folderClass) || !this.propertyClass.equals(migrator.propertyClass)) continue;
            migrator.apply(f, p);
            return;
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyMigration migration = (PropertyMigration)o;
        if (!this.folderClass.equals(migration.folderClass)) {
            return false;
        }
        if (!this.propertyClass.equals(migration.propertyClass)) {
            return false;
        }
        return this.pluginName.equals(migration.pluginName);
    }

    public final int hashCode() {
        int result = this.folderClass.hashCode();
        result = 31 * result + this.propertyClass.hashCode();
        result = 31 * result + this.pluginName.hashCode();
        return result;
    }

    public static void applyAll(AbstractFolder<?> folder) {
        DescribableList properties = folder.getProperties();
        for (PropertyMigration migration : ExtensionList.lookup(PropertyMigration.class)) {
            if (!migration.isEnabled() || !migration.folderClass.isInstance(folder) || properties.get(migration.propertyClass) == null) continue;
            if (migration.canApply()) {
                migration.apply(folder);
                continue;
            }
            MonitorImpl monitor = (MonitorImpl)((Object)ExtensionList.lookup(AdministrativeMonitor.class).get(MonitorImpl.class));
            if (monitor != null) {
                monitor.add(migration);
                continue;
            }
            LOGGER.log(Level.SEVERE, "{0} is loaded but no {1} singleton present.", new Object[]{PropertyMigration.class, MonitorImpl.class});
        }
    }

    @Extension
    public static class MonitorImpl
    extends AdministrativeMonitor {
        private Set<PropertyMigration<?, ?>> missing = new HashSet();

        public boolean isActivated() {
            return !this.missing.isEmpty();
        }

        public List<PropertyMigration<?, ?>> getPending() {
            ArrayList result = new ArrayList(this.missing.size());
            for (PropertyMigration<?, ?> m : this.missing) {
                if (m.canApply()) continue;
                result.add(m);
            }
            Collections.sort(result, new Comparator<PropertyMigration<?, ?>>(){

                @Override
                public int compare(PropertyMigration<?, ?> o1, PropertyMigration<?, ?> o2) {
                    return o1.getClass().getName().compareTo(o2.getClass().getName());
                }
            });
            return result;
        }

        public boolean isReady() {
            for (PropertyMigration<?, ?> m : this.missing) {
                if (m.canApply()) continue;
                return false;
            }
            return true;
        }

        public synchronized void add(PropertyMigration<?, ?> migration) {
            this.missing.add(migration);
        }
    }

    public static abstract class Migrator<F extends AbstractFolder<?>, P extends AbstractFolderProperty<F>>
    implements ExtensionPoint {
        private final Class<F> folderClass;
        private final Class<P> propertyClass;

        public Migrator(Class<F> folderClass, Class<P> propertyClass) {
            this.folderClass = folderClass;
            this.propertyClass = propertyClass;
        }

        public final boolean isApplicable(AbstractFolder<?> folder) {
            return this.folderClass.isInstance(folder) && folder.getProperties().get(this.propertyClass) != null;
        }

        public abstract void apply(F var1, P var2);
    }
}

