/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetric;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Actionable;
import hudson.model.HealthReport;
import hudson.model.Item;
import hudson.model.Job;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import org.kohsuke.stapler.DataBoundConstructor;

public class PrimaryBranchHealthMetric
extends FolderHealthMetric {
    @DataBoundConstructor
    public PrimaryBranchHealthMetric() {
    }

    public FolderHealthMetric.Reporter reporter() {
        return new ReporterImpl();
    }

    public FolderHealthMetric.Type getType() {
        return FolderHealthMetric.Type.IMMEDIATE_TOP_LEVEL_ITEMS;
    }

    private static class ReporterImpl
    implements FolderHealthMetric.Reporter {
        @CheckForNull
        private List<HealthReport> reports;

        private ReporterImpl() {
        }

        public void observe(Item item) {
            if (item instanceof Actionable && ((Actionable)item).getAction(PrimaryInstanceMetadataAction.class) != null && this.reports == null) {
                this.reports = new ArrayList<HealthReport>();
                this.reports.addAll(Util.fixNull(ReporterImpl.getHealthReports(item)));
            }
        }

        public static List<HealthReport> getHealthReports(Item item) {
            if (item instanceof Job) {
                return ((Job)item).getBuildHealthReports();
            }
            if (item instanceof Folder) {
                return ((Folder)item).getBuildHealthReports();
            }
            try {
                Method getBuildHealth = item.getClass().getMethod("getBuildHealthReports", new Class[0]);
                return (List)getBuildHealth.invoke((Object)item, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException var2) {
                HealthReport report = FolderHealthMetric.getHealthReport((Item)item);
                return report == null ? null : Collections.singletonList(report);
            }
        }

        public List<HealthReport> report() {
            return Util.fixNull(this.reports);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends FolderHealthMetricDescriptor {
        public String getDisplayName() {
            return "Health of the primary branch of a repository";
        }

        public boolean isApplicable(Class<? extends AbstractFolder> containerType) {
            return MultiBranchProject.class.isAssignableFrom(containerType);
        }
    }
}

