/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import antlr.ANTLRException;
import com.cloudbees.hudson.plugins.folder.computed.PeriodicFolderTrigger;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.DescribableList;
import hudson.util.XStream2;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jenkins.branch.Messages;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.branch.OrganizationFolder;
import jenkins.branch.OrganizationFolderProperty;
import jenkins.branch.OrganizationFolderPropertyDescriptor;
import org.jvnet.tiger_types.Types;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class OrganizationChildTriggersProperty
extends OrganizationFolderProperty<OrganizationFolder> {
    @NonNull
    private final List<Trigger<?>> templates;
    @CheckForNull
    private transient Map<Trigger<?>, String> templateXML;

    @DataBoundConstructor
    public OrganizationChildTriggersProperty(List<Trigger<?>> templates) {
        this.templates = new ArrayList(Util.fixNull(templates));
    }

    public OrganizationChildTriggersProperty(Trigger<?> ... templates) {
        this(Arrays.asList(templates));
    }

    public static OrganizationChildTriggersProperty newDefaultInstance() {
        try {
            return new OrganizationChildTriggersProperty(new Trigger[]{new PeriodicFolderTrigger("1d")});
        }
        catch (ANTLRException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<Trigger<?>> getTemplates() {
        return new DescribableList(Saveable.NOOP, this.templates);
    }

    @NonNull
    private String templateXML(@NonNull Trigger<?> template) {
        if (this.templateXML == null) {
            this.templateXML = new ConcurrentHashMap();
        }
        return this.templateXML.computeIfAbsent(template, arg_0 -> ((XStream2)Items.XSTREAM2).toXML(arg_0));
    }

    private boolean sameAsTemplate(Trigger<?> template, Trigger<?> trigger) {
        return this.templateXML(template).equals(Items.XSTREAM2.toXML(trigger));
    }

    private <T extends Trigger> T newInstance(T template) {
        return (T)((Trigger)Items.XSTREAM2.fromXML(this.templateXML(template)));
    }

    @Override
    protected void decorate(@NonNull MultiBranchProject<?, ?> child, @NonNull TaskListener listener) throws IOException {
        Map childTriggers = child.getTriggers();
        IdentityHashMap<Trigger, Boolean> toRemove = new IdentityHashMap<Trigger, Boolean>(childTriggers.size());
        ArrayList toAddOrUpdate = new ArrayList();
        childTriggers.forEach((d, t) -> toRemove.put((Trigger)t, Boolean.TRUE));
        for (Trigger<?> trigger2 : this.templates) {
            Trigger current = (Trigger)childTriggers.get(trigger2.getDescriptor());
            if (current != null) {
                toRemove.remove(current);
                if (this.sameAsTemplate(trigger2, current)) continue;
                toAddOrUpdate.add(this.newInstance(trigger2));
                continue;
            }
            toAddOrUpdate.add(this.newInstance(trigger2));
        }
        for (Trigger trigger3 : toAddOrUpdate) {
            child.addTrigger(trigger3);
        }
        toRemove.forEach((trigger, ignore) -> child.removeTrigger((Trigger)trigger));
    }

    @Extension
    public static class DescriptorImpl
    extends OrganizationFolderPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.OrganizationChildTriggersProperty_DisplayName();
        }

        @Restricted(value={DoNotUse.class})
        public List<TriggerDescriptor> getTriggerDescriptors() {
            List mbpDescriptors = MultiBranchProjectDescriptor.all().stream().filter(MultiBranchProjectDescriptor.class::isInstance).map(MultiBranchProjectDescriptor.class::cast).collect(Collectors.toList());
            ArrayList<TriggerDescriptor> result = new ArrayList<TriggerDescriptor>();
            for (TriggerDescriptor triggerDescriptor : Trigger.all()) {
                ParameterizedType pt;
                Class t;
                Type bt;
                if (triggerDescriptor instanceof TimerTrigger.DescriptorImpl || triggerDescriptor instanceof SCMTrigger.DescriptorImpl) continue;
                boolean atLeastOne = false;
                for (MultiBranchProjectDescriptor d : mbpDescriptors) {
                    if (!d.isApplicable((Descriptor)triggerDescriptor)) continue;
                    atLeastOne = true;
                    break;
                }
                if (!atLeastOne || !((bt = Types.getBaseClass((Type)triggerDescriptor.clazz, Trigger.class)) instanceof ParameterizedType) || !(t = Types.erasure((Type)(pt = (ParameterizedType)bt).getActualTypeArguments()[0])).isAssignableFrom(MultiBranchProject.class)) continue;
                result.add(triggerDescriptor);
            }
            return result;
        }
    }
}

