/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.brakeman.scanners;

import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.brakeman.Warning;
import hudson.plugins.brakeman.scanners.AbstractBrakemanScanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BrakemanTabsScanner
extends AbstractBrakemanScanner {
    private boolean result = true;
    private static Pattern pattern = Pattern.compile("^([^\t]+?)\t(\\d+)\t([\\w\\s]+?)\t(\\w+)\t([^\t]+?)\t(High|Medium|Weak|Info)", 8);

    @Override
    public boolean scan(String content, ParserResult project, PluginLogger logger) {
        Matcher m = pattern.matcher(content);
        this.scanWarnings(m, project);
        return this.result;
    }

    private void scanWarnings(Matcher m, ParserResult project) {
        while (m.find()) {
            String fileName = m.group(1);
            int line = Integer.parseInt(m.group(2));
            String type = m.group(3);
            String category = m.group(4);
            String message = m.group(5);
            Priority priority = this.checkPriority(m.group(6));
            project.addAnnotation((FileAnnotation)new Warning(fileName, this.getStart(line), this.getEnd(line), type, category, message, priority));
        }
    }
}

