/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.brakeman.scanners;

import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.brakeman.Warning;
import hudson.plugins.brakeman.scanners.AbstractBrakemanScanner;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class BrakemanJSONScanner
extends AbstractBrakemanScanner {
    @Override
    public boolean scan(String content, ParserResult project, PluginLogger logger) {
        boolean result = true;
        try {
            JSONObject brakemanFile = JSONObject.fromObject((Object)content);
            this.scanJSONResultSet(brakemanFile, project, "warnings");
            this.scanJSONResultSet(brakemanFile, project, "ignored_warnings");
        }
        catch (JSONException e) {
            result = false;
            logger.log(String.format("%s", e.getMessage()));
        }
        return result;
    }

    private void scanJSONResultSet(JSONObject brakemanResultFile, ParserResult project, String filterType) throws JSONException {
        JSONArray rows = brakemanResultFile.getJSONArray(filterType);
        for (int i = 0; i < rows.size(); ++i) {
            String code;
            JSONObject row = rows.getJSONObject(i);
            String fileName = row.getString("file");
            String type = row.getString("warning_type");
            String category = this.getCategory(filterType).getName();
            StringBuilder message = new StringBuilder();
            message.append(row.getString("message"));
            if (row.has("code") && !(code = row.optString("code", "")).isEmpty()) {
                message.append(": ").append(row.getString("code"));
            }
            int line = row.optInt("line", 1);
            Priority priority = this.checkPriority(row.getString("confidence"));
            if (row.has("description")) {
                String description = row.getString("description");
                project.addAnnotation((FileAnnotation)new Warning(fileName, this.getStart(line), this.getEnd(line), type, category, message.toString(), description, priority));
                continue;
            }
            project.addAnnotation((FileAnnotation)new Warning(fileName, this.getStart(line), this.getEnd(line), type, category, message.toString(), priority));
        }
    }

    private Category getCategory(String filterType) {
        Category category = filterType == "ignored_warnings" ? Category.IGNORED : Category.GENERAL;
        return category;
    }

    public static enum Category {
        GENERAL,
        IGNORED;


        public String getName() {
            return StringUtils.capitalize((String)this.name().toLowerCase());
        }
    }
}

