/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.brakeman;

import hudson.plugins.brakeman.BrakemanResult;
import hudson.plugins.brakeman.Messages;

public final class ResultSummary {
    public static String createSummary(BrakemanResult result) {
        StringBuilder summary = new StringBuilder();
        int bugs = result.getNumberOfNonIgnoredAnnotations();
        int ignoredBugs = result.getNumberOfIgnoredAnnotations();
        summary.append(Messages.Brakeman_ProjectAction_Name());
        summary.append(": ");
        if (bugs > 0 || ignoredBugs > 0) {
            summary.append("<a href=\"brakemanResult\">");
        }
        if (bugs == 1) {
            summary.append(Messages.Brakeman_ResultAction_OneWarning());
            summary.append(". ");
        } else {
            summary.append(Messages.Brakeman_ResultAction_MultipleWarnings(bugs));
            summary.append(". ");
        }
        if (ignoredBugs == 1) {
            summary.append(Messages.Brakeman_ResultAction_OneIgnoredWarning());
        } else {
            summary.append(Messages.Brakeman_ResultAction_MultipleIgnoredWarnings(ignoredBugs));
        }
        if (bugs > 0 || ignoredBugs > 0) {
            summary.append("</a>");
        }
        summary.append(".");
        return summary.toString();
    }

    public static String createDeltaMessage(BrakemanResult result) {
        StringBuilder summary = new StringBuilder();
        if (result.getNumberOfNewWarnings() > 0) {
            summary.append("<li><a href=\"brakemanResult/new\">");
            if (result.getNumberOfNewWarnings() == 1) {
                summary.append(Messages.Brakeman_ResultAction_OneNewWarning());
            } else {
                summary.append(Messages.Brakeman_ResultAction_MultipleNewWarnings(result.getNumberOfNewWarnings()));
            }
            summary.append("</a></li>");
        }
        if (result.getNumberOfFixedWarnings() > 0) {
            summary.append("<li><a href=\"brakemanResult/fixed\">");
            if (result.getNumberOfFixedWarnings() == 1) {
                summary.append(Messages.Brakeman_ResultAction_OneFixedWarning());
            } else {
                summary.append(Messages.Brakeman_ResultAction_MultipleFixedWarnings(result.getNumberOfFixedWarnings()));
            }
            summary.append("</a></li>");
        }
        return summary.toString();
    }

    private ResultSummary() {
    }
}

