/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.brakeman;

import com.thoughtworks.xstream.XStream;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.BuildResultEvaluator;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.core.Thresholds;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.brakeman.BrakemanResultAction;
import hudson.plugins.brakeman.Messages;
import hudson.plugins.brakeman.ResultSummary;
import hudson.plugins.brakeman.ScanResult;
import hudson.plugins.brakeman.Warning;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BrakemanResult
extends BuildResult {
    private static final long serialVersionUID = -137460587767210579L;
    private transient boolean useDeltaValues;
    private transient Thresholds thresholds = new Thresholds();
    private transient BuildHistory history;
    private String reason;

    public BrakemanResult(Run<?, ?> build, String defaultEncoding, ParserResult result, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, ScanResult scanResult) {
        this(build, defaultEncoding, result, usePreviousBuildAsReference, useStableBuildAsReference, BrakemanResultAction.class);
        this.validateScan(scanResult);
    }

    protected BrakemanResult(Run<?, ?> build, String defaultEncoding, ParserResult result, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, Class<? extends ResultAction<BrakemanResult>> actionType) {
        this(build, new BuildHistory(build, actionType, usePreviousBuildAsReference, useStableBuildAsReference), result, defaultEncoding, true);
    }

    private BrakemanResult(Run<?, ?> build, BuildHistory history, ParserResult result, String defaultEncoding, boolean canSerialize) {
        super(build, history, result, defaultEncoding);
        if (canSerialize) {
            this.serializeAnnotations(result.getAnnotations());
        }
    }

    protected void configure(XStream xstream) {
        xstream.alias("warning", Warning.class);
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    protected String createDeltaMessage() {
        return ResultSummary.createDeltaMessage(this);
    }

    protected String getSerializationFileName() {
        return "compiler-Brakeman.xml";
    }

    public String getDisplayName() {
        return Messages.Brakeman_ProjectAction_Name();
    }

    protected void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public void evaluateStatus(Thresholds thresholds, boolean useDeltaValues, PluginLogger logger, String url) {
        this.evaluateStatus(thresholds, useDeltaValues, true, logger, url);
    }

    public void evaluateStatus(Thresholds thresholds, boolean useDeltaValues, boolean canComputeNew, PluginLogger logger, String url) {
        if (!this.hasError()) {
            Result buildResult;
            this.thresholds = thresholds;
            this.useDeltaValues = useDeltaValues;
            BuildResultEvaluator resultEvaluator = new BuildResultEvaluator(url);
            StringBuilder messages = new StringBuilder();
            Set<FileAnnotation> annotations = this.getNonIgnoredAnnotations();
            if (this.getHistory().isEmpty() || !canComputeNew) {
                logger.log("Ignore new warnings since this is the first valid build");
                buildResult = resultEvaluator.evaluateBuildResult(messages, thresholds, annotations);
            } else {
                buildResult = useDeltaValues ? resultEvaluator.evaluateBuildResult(messages, thresholds, annotations, this.getDelta(), this.getHighDelta(), this.getNormalDelta(), this.getLowDelta()) : resultEvaluator.evaluateBuildResult(messages, thresholds, annotations, this.getNewWarnings());
            }
            this.setReason(messages.toString());
            this.setResult(buildResult);
            logger.log(String.format("%s %s - %s", Messages.Brakeman_ResultAction_Status(), buildResult.color.getDescription(), this.getReason()));
        }
    }

    private Set<FileAnnotation> getIgnoredAnnotations() {
        Set myAnnotations = this.getAnnotations();
        Iterator itr = myAnnotations.iterator();
        HashSet<FileAnnotation> annotations = new HashSet<FileAnnotation>();
        while (itr.hasNext()) {
            FileAnnotation a = (FileAnnotation)itr.next();
            if (!a.getCategory().equals("Ignored")) continue;
            annotations.add(a);
        }
        return annotations;
    }

    private Set<FileAnnotation> getNonIgnoredAnnotations() {
        Set myAnnotations = this.getAnnotations();
        Iterator itr = myAnnotations.iterator();
        HashSet<FileAnnotation> annotations = new HashSet<FileAnnotation>();
        while (itr.hasNext()) {
            FileAnnotation a = (FileAnnotation)itr.next();
            if (a.getCategory().equals("Ignored")) continue;
            annotations.add(a);
        }
        return annotations;
    }

    protected int getNumberOfIgnoredAnnotations() {
        Set<FileAnnotation> annotations = this.getIgnoredAnnotations();
        int result = annotations.size();
        return result;
    }

    protected int getNumberOfNonIgnoredAnnotations() {
        Set<FileAnnotation> annotations = this.getNonIgnoredAnnotations();
        int result = annotations.size();
        return result;
    }

    private void validateScan(ScanResult result) {
        if (!result.isSuccessful()) {
            StringBuilder report = new StringBuilder();
            report.append("Brakeman Reports File Invalid. File: ");
            report.append(result.getFilename());
            report.append(" could not be ready properly. Please check console for additional information.");
            this.getErrors().add(report.toString());
            this.setReason("Reading of Brakeman output failed. Check logs and errors for more information.");
            this.setResult(Result.FAILURE);
        }
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return BrakemanResultAction.class;
    }
}

